/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;

public class RoundRobinLoadBalancingStrategy
implements LoadBalancingStrategy {
    private final AtomicInteger currentHandlerIndex = new AtomicInteger();

    @Override
    public final Iterator<MessageHandler> getHandlerIterator(Message<?> message, Collection<MessageHandler> handlers) {
        int size = handlers.size();
        if (size < 2) {
            this.getNextHandlerStartIndex(size);
            return handlers.iterator();
        }
        return this.buildHandlerIterator(size, handlers.toArray(new MessageHandler[size]));
    }

    private Iterator<MessageHandler> buildHandlerIterator(int size, MessageHandler[] handlers) {
        int nextHandlerStartIndex = this.getNextHandlerStartIndex(size);
        final MessageHandler[] reorderedHandlers = new MessageHandler[size];
        System.arraycopy(handlers, nextHandlerStartIndex, reorderedHandlers, 0, size - nextHandlerStartIndex);
        System.arraycopy(handlers, 0, reorderedHandlers, size - nextHandlerStartIndex, 0 + nextHandlerStartIndex);
        return new Iterator<MessageHandler>(){
            int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < reorderedHandlers.length;
            }

            @Override
            public MessageHandler next() {
                return reorderedHandlers[this.currentIndex++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported by this Iterator");
            }
        };
    }

    private int getNextHandlerStartIndex(int size) {
        if (size > 0) {
            int indexTail = this.currentHandlerIndex.getAndIncrement() % size;
            return indexTail < 0 ? indexTail + size : indexTail;
        }
        return size;
    }
}

