/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.messaging.MessagingException;

public class GatewayCompletableFutureProxyFactoryBean
extends GatewayProxyFactoryBean {
    public GatewayCompletableFutureProxyFactoryBean() {
    }

    public GatewayCompletableFutureProxyFactoryBean(Class<?> serviceInterface) {
        super(serviceInterface);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        AsyncTaskExecutor asyncExecutor;
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (CompletableFuture.class.equals(returnType) && (asyncExecutor = this.getAsyncExecutor()) != null) {
            return CompletableFuture.supplyAsync(new Invoker(invocation), (Executor)asyncExecutor);
        }
        return super.invoke(invocation);
    }

    private final class Invoker
    implements Supplier<Object> {
        private final MethodInvocation invocation;

        private Invoker(MethodInvocation methodInvocation) {
            this.invocation = methodInvocation;
        }

        @Override
        public Object get() {
            try {
                return GatewayCompletableFutureProxyFactoryBean.this.doInvoke(this.invocation, false);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new MessagingException("asynchronous gateway invocation failed", t);
            }
        }
    }
}

