/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.leader.event.AbstractLeaderEvent;
import org.springframework.integration.leader.event.OnGrantedEvent;
import org.springframework.integration.leader.event.OnRevokedEvent;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class SmartLifecycleRoleController
implements ApplicationListener<AbstractLeaderEvent>,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SmartLifecycleRoleController.class);
    private final MultiValueMap<String, SmartLifecycle> lifecycles = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> lazyLifecycles = new LinkedMultiValueMap();
    private ApplicationContext applicationContext;

    public SmartLifecycleRoleController(List<String> roles, List<SmartLifecycle> lifecycles) {
        Assert.notNull(roles, (String)"'roles' cannot be null");
        Assert.notNull(lifecycles, (String)"'lifecycles' cannot be null");
        Assert.isTrue((roles.size() == lifecycles.size() ? 1 : 0) != 0, (String)"'roles' and 'lifecycles' must be the same lenght");
        Iterator<SmartLifecycle> iterator = lifecycles.iterator();
        for (String role : roles) {
            SmartLifecycle lifecycle = iterator.next();
            this.addLifecycleToRole(role, lifecycle);
        }
    }

    public SmartLifecycleRoleController(MultiValueMap<String, SmartLifecycle> lifcycles) {
        for (Map.Entry lifecyclesInRole : lifcycles.entrySet()) {
            String role = (String)lifecyclesInRole.getKey();
            for (SmartLifecycle lifecycle : (List)lifecyclesInRole.getValue()) {
                this.addLifecycleToRole(role, lifecycle);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public final void addLifecycleToRole(String role, SmartLifecycle lifecycle) {
        this.lifecycles.add((Object)role, (Object)lifecycle);
    }

    public void addLifecycleToRole(String role, String lifecycleBeanName) {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"An application context is required to use this method");
        this.lazyLifecycles.add((Object)role, (Object)lifecycleBeanName);
    }

    public void addLifecyclesToRole(String role, List<String> lifecycleBeanNames) {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"An application context is required to use this method");
        for (String lifecycleBeanName : lifecycleBeanNames) {
            this.lazyLifecycles.add((Object)role, (Object)lifecycleBeanName);
        }
    }

    public void startLifecyclesInRole(String role) {
        ArrayList lifecycles;
        if (this.lazyLifecycles.size() > 0) {
            this.addLazyLifecycles();
        }
        if ((lifecycles = (ArrayList)this.lifecycles.get((Object)role)) != null) {
            lifecycles = new ArrayList(lifecycles);
            Collections.sort(lifecycles, new Comparator<SmartLifecycle>(){

                @Override
                public int compare(SmartLifecycle o1, SmartLifecycle o2) {
                    return o1.getPhase() < o2.getPhase() ? -1 : (o1.getPhase() > o2.getPhase() ? 1 : 0);
                }
            });
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting " + lifecycles + " in role " + role));
            }
            for (SmartLifecycle lifecycle : lifecycles) {
                try {
                    lifecycle.start();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to start " + lifecycle + " in role " + role), (Throwable)e);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No components in role " + role + ". Nothing to start"));
        }
    }

    public void stopLifecyclesInRole(String role) {
        ArrayList lifecycles;
        if (this.lazyLifecycles.size() > 0) {
            this.addLazyLifecycles();
        }
        if ((lifecycles = (ArrayList)this.lifecycles.get((Object)role)) != null) {
            lifecycles = new ArrayList(lifecycles);
            Collections.sort(lifecycles, new Comparator<SmartLifecycle>(){

                @Override
                public int compare(SmartLifecycle o1, SmartLifecycle o2) {
                    return o1.getPhase() < o2.getPhase() ? 1 : (o1.getPhase() > o2.getPhase() ? -1 : 0);
                }
            });
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Stopping " + lifecycles + " in role " + role));
            }
            for (SmartLifecycle lifecycle : lifecycles) {
                try {
                    lifecycle.stop();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to stop " + lifecycle + " in role " + role), (Throwable)e);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No components in role " + role + ". Nothing to stop"));
        }
    }

    public Collection<String> getRoles() {
        if (this.lazyLifecycles.size() > 0) {
            this.addLazyLifecycles();
        }
        return new ArrayList<String>(this.lifecycles.keySet());
    }

    public boolean allEndpointsRunning(String role) {
        Map<String, Boolean> status = this.getEndpointsRunningStatus(role);
        if (status.isEmpty()) {
            return false;
        }
        for (Boolean isRunning : status.values()) {
            if (isRunning.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean noEndpointsRunning(String role) {
        Map<String, Boolean> status = this.getEndpointsRunningStatus(role);
        for (Boolean isRunning : status.values()) {
            if (!isRunning.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Map<String, Boolean> getEndpointsRunningStatus(String role) {
        List endpoints;
        if (this.lazyLifecycles.size() > 0) {
            this.addLazyLifecycles();
        }
        if ((endpoints = (List)this.lifecycles.get((Object)role)) == null || endpoints.isEmpty()) {
            return Collections.emptyMap();
        }
        int index = 0;
        HashMap<String, Boolean> runners = new HashMap<String, Boolean>();
        for (SmartLifecycle lifecycle : endpoints) {
            runners.put(lifecycle instanceof NamedComponent ? ((NamedComponent)lifecycle).getComponentName() : lifecycle.getClass().getSimpleName() + "#" + index++, lifecycle.isRunning());
        }
        return runners;
    }

    private synchronized void addLazyLifecycles() {
        for (Map.Entry entry : this.lazyLifecycles.entrySet()) {
            this.doAddLifecyclesToRole((String)entry.getKey(), (List)entry.getValue());
        }
        this.lazyLifecycles.clear();
    }

    private void doAddLifecyclesToRole(String role, List<String> lifecycleBeanNames) {
        for (String lifecycleBeanName : lifecycleBeanNames) {
            try {
                SmartLifecycle lifecycle = (SmartLifecycle)this.applicationContext.getBean(lifecycleBeanName, SmartLifecycle.class);
                this.addLifecycleToRole(role, lifecycle);
            }
            catch (NoSuchBeanDefinitionException e) {
                logger.warn((Object)("Skipped; no such bean: " + lifecycleBeanName));
            }
        }
    }

    public void onApplicationEvent(AbstractLeaderEvent event) {
        if (event instanceof OnGrantedEvent) {
            this.startLifecyclesInRole(event.getRole());
        } else if (event instanceof OnRevokedEvent) {
            this.stopLifecyclesInRole(event.getRole());
        }
    }
}

