/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ContentEnricher
extends AbstractReplyProducingMessageHandler
implements Lifecycle {
    private final SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private volatile Map<Expression, Expression> nullResultPropertyExpressions = new HashMap<Expression, Expression>();
    private volatile Map<String, HeaderValueMessageProcessor<?>> nullResultHeaderExpressions = new HashMap();
    private volatile Map<Expression, Expression> propertyExpressions = new HashMap<Expression, Expression>();
    private volatile Map<String, HeaderValueMessageProcessor<?>> headerExpressions = new HashMap();
    private EvaluationContext sourceEvaluationContext;
    private EvaluationContext targetEvaluationContext;
    private volatile boolean shouldClonePayload = false;
    private Expression requestPayloadExpression;
    private volatile MessageChannel requestChannel;
    private volatile String requestChannelName;
    private volatile MessageChannel replyChannel;
    private volatile String replyChannelName;
    private volatile MessageChannel errorChannel;
    private volatile String errorChannelName;
    private volatile Gateway gateway = null;
    private volatile Long requestTimeout;
    private volatile Long replyTimeout;

    public void setNullResultPropertyExpressions(Map<String, Expression> nullResultPropertyExpressions) {
        HashMap<Expression, Expression> localMap = new HashMap<Expression, Expression>(nullResultPropertyExpressions.size());
        for (Map.Entry<String, Expression> entry : nullResultPropertyExpressions.entrySet()) {
            String key = entry.getKey();
            Expression value = entry.getValue();
            localMap.put(this.parser.parseExpression(key), value);
        }
        this.nullResultPropertyExpressions = localMap;
    }

    public void setNullResultHeaderExpressions(Map<String, HeaderValueMessageProcessor<?>> nullResultHeaderExpressions) {
        this.nullResultHeaderExpressions = new HashMap(nullResultHeaderExpressions);
    }

    public void setPropertyExpressions(Map<String, Expression> propertyExpressions) {
        Assert.notEmpty(propertyExpressions, (String)"propertyExpressions must not be empty");
        Assert.noNullElements((Object[])propertyExpressions.keySet().toArray(), (String)"propertyExpressions keys must not be empty");
        Assert.noNullElements((Object[])propertyExpressions.values().toArray(), (String)"propertyExpressions values must not be empty");
        HashMap<Expression, Expression> localMap = new HashMap<Expression, Expression>(propertyExpressions.size());
        for (Map.Entry<String, Expression> entry : propertyExpressions.entrySet()) {
            String key = entry.getKey();
            Expression value = entry.getValue();
            localMap.put(this.parser.parseExpression(key), value);
        }
        this.propertyExpressions = localMap;
    }

    public void setHeaderExpressions(Map<String, HeaderValueMessageProcessor<?>> headerExpressions) {
        Assert.notEmpty(headerExpressions, (String)"headerExpressions must not be empty");
        Assert.noNullElements((Object[])headerExpressions.keySet().toArray(), (String)"headerExpressions keys must not be empty");
        Assert.noNullElements((Object[])headerExpressions.values().toArray(), (String)"headerExpressions values must not be empty");
        this.headerExpressions = new HashMap(headerExpressions);
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.requestChannel = requestChannel;
    }

    public void setRequestChannelName(String requestChannelName) {
        Assert.hasText((String)requestChannelName, (String)"'requestChannelName' must not be empty");
        this.requestChannelName = requestChannelName;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.replyChannel = replyChannel;
    }

    public void setReplyChannelName(String replyChannelName) {
        Assert.hasText((String)replyChannelName, (String)"'replyChannelName' must not be empty");
        this.replyChannelName = replyChannelName;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setErrorChannelName(String errorChannelName) {
        Assert.hasText((String)errorChannelName, (String)"'errorChannelName' must not be empty");
        this.errorChannelName = errorChannelName;
    }

    public void setRequestTimeout(Long requestTimeout) {
        Assert.notNull((Object)requestTimeout, (String)"requestTimeout must not be null");
        this.requestTimeout = requestTimeout;
    }

    public void setReplyTimeout(Long replyTimeout) {
        Assert.notNull((Object)replyTimeout, (String)"replyTimeout must not be null");
        this.replyTimeout = replyTimeout;
    }

    public void setRequestPayloadExpression(Expression requestPayloadExpression) {
        this.requestPayloadExpression = requestPayloadExpression;
    }

    public void setShouldClonePayload(boolean shouldClonePayload) {
        this.shouldClonePayload = shouldClonePayload;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.sourceEvaluationContext = evaluationContext;
    }

    @Override
    public String getComponentType() {
        return "enricher";
    }

    @Override
    protected void doInit() {
        Assert.state((this.requestChannelName == null || this.requestChannel == null ? 1 : 0) != 0, (String)"'requestChannelName' and 'requestChannel' are mutually exclusive.");
        Assert.state((this.replyChannelName == null || this.replyChannel == null ? 1 : 0) != 0, (String)"'replyChannelName' and 'replyChannel' are mutually exclusive.");
        Assert.state((this.errorChannelName == null || this.errorChannel == null ? 1 : 0) != 0, (String)"'errorChannelName' and 'errorChannel' are mutually exclusive.");
        if (this.replyChannel != null || this.replyChannelName != null) {
            Assert.state((this.requestChannel != null || this.requestChannelName != null ? 1 : 0) != 0, (String)"If the replyChannel is set, then the requestChannel must not be null");
        }
        if (this.errorChannel != null || this.errorChannelName != null) {
            Assert.state((this.requestChannel != null || this.requestChannelName != null ? 1 : 0) != 0, (String)"If the errorChannel is set, then the requestChannel must not be null");
        }
        if (this.requestChannel != null || this.requestChannelName != null) {
            this.gateway = new Gateway();
            this.gateway.setRequestChannel(this.requestChannel);
            if (this.requestChannelName != null) {
                this.gateway.setRequestChannelName(this.requestChannelName);
            }
            if (this.requestTimeout != null) {
                this.gateway.setRequestTimeout(this.requestTimeout);
            }
            if (this.replyTimeout != null) {
                this.gateway.setReplyTimeout(this.replyTimeout);
            }
            this.gateway.setReplyChannel(this.replyChannel);
            if (this.replyChannelName != null) {
                this.gateway.setReplyChannelName(this.replyChannelName);
            }
            this.gateway.setErrorChannel(this.errorChannel);
            if (this.errorChannelName != null) {
                this.gateway.setErrorChannelName(this.errorChannelName);
            }
            if (this.getBeanFactory() != null) {
                this.gateway.setBeanFactory(this.getBeanFactory());
            }
            this.gateway.afterPropertiesSet();
        }
        if (this.sourceEvaluationContext == null) {
            this.sourceEvaluationContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
        }
        StandardEvaluationContext targetContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
        targetContext.setBeanResolver(null);
        this.targetEvaluationContext = targetContext;
        if (this.getBeanFactory() != null) {
            boolean checkReadOnlyHeaders = this.getMessageBuilderFactory() instanceof DefaultMessageBuilderFactory;
            for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.headerExpressions.entrySet()) {
                if (checkReadOnlyHeaders && ("id".equals(entry.getKey()) || "timestamp".equals(entry.getKey()))) {
                    this.logger.warn((Object)("ContentEnricher cannot override 'id' and 'timestamp' read-only headers.\nWrong 'headerExpressions' [" + this.headerExpressions + "] configuration for " + this.getComponentName()));
                }
                if (!(entry.getValue() instanceof BeanFactoryAware)) continue;
                ((BeanFactoryAware)entry.getValue()).setBeanFactory(this.getBeanFactory());
            }
            for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.nullResultHeaderExpressions.entrySet()) {
                if (checkReadOnlyHeaders && ("id".equals(entry.getKey()) || "timestamp".equals(entry.getKey()))) {
                    this.logger.warn((Object)("ContentEnricher cannot override 'id' and 'timestamp' read-only headers.\nWrong 'nullResultHeaderExpressions' [" + this.nullResultHeaderExpressions + "] configuration for " + this.getComponentName()));
                }
                if (!(entry.getValue() instanceof BeanFactoryAware)) continue;
                ((BeanFactoryAware)entry.getValue()).setBeanFactory(this.getBeanFactory());
            }
        }
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        Message<?> replyMessage;
        Object actualRequestMessage;
        Object targetPayload;
        Object requestPayload = requestMessage.getPayload();
        if (requestPayload instanceof Cloneable && this.shouldClonePayload) {
            try {
                Method cloneMethod = requestPayload.getClass().getMethod("clone", new Class[0]);
                targetPayload = ReflectionUtils.invokeMethod((Method)cloneMethod, (Object)requestPayload);
            }
            catch (Exception e) {
                throw new MessageHandlingException(requestMessage, "Failed to clone payload object", (Throwable)e);
            }
        } else {
            targetPayload = requestPayload;
        }
        if (this.requestPayloadExpression == null) {
            actualRequestMessage = requestMessage;
        } else {
            Object requestMessagePayload = this.requestPayloadExpression.getValue(this.sourceEvaluationContext, requestMessage);
            actualRequestMessage = this.getMessageBuilderFactory().withPayload(requestMessagePayload).copyHeaders((Map<String, ?>)requestMessage.getHeaders()).build();
        }
        if (this.gateway == null) {
            replyMessage = actualRequestMessage;
        } else {
            replyMessage = this.gateway.sendAndReceiveMessage(actualRequestMessage);
            if (replyMessage == null) {
                if (this.nullResultPropertyExpressions.isEmpty() && this.nullResultHeaderExpressions.isEmpty()) {
                    return null;
                }
                for (Map.Entry<Expression, Expression> entry : this.nullResultPropertyExpressions.entrySet()) {
                    Expression expression = entry.getKey();
                    Expression valueExpression = entry.getValue();
                    Object value = valueExpression.getValue(this.sourceEvaluationContext, requestMessage);
                    expression.setValue(this.targetEvaluationContext, targetPayload, value);
                }
                if (this.nullResultHeaderExpressions.isEmpty()) {
                    return targetPayload;
                }
                HashMap targetHeaders = new HashMap(this.nullResultHeaderExpressions.size());
                for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.nullResultHeaderExpressions.entrySet()) {
                    String header = entry.getKey();
                    HeaderValueMessageProcessor<?> valueProcessor = entry.getValue();
                    Boolean overwrite = valueProcessor.isOverwrite();
                    overwrite = overwrite != null ? overwrite : true;
                    if (!overwrite.booleanValue() && requestMessage.getHeaders().containsKey((Object)header)) continue;
                    Object value = valueProcessor.processMessage(requestMessage);
                    targetHeaders.put(header, value);
                }
                return this.getMessageBuilderFactory().withPayload(targetPayload).copyHeaders(targetHeaders).build();
            }
        }
        for (Map.Entry<Expression, Expression> entry : this.propertyExpressions.entrySet()) {
            Expression expression = entry.getKey();
            Expression valueExpression = entry.getValue();
            Object value = valueExpression.getValue(this.sourceEvaluationContext, replyMessage);
            expression.setValue(this.targetEvaluationContext, targetPayload, value);
        }
        if (this.headerExpressions.isEmpty()) {
            return targetPayload;
        }
        HashMap targetHeaders = new HashMap(this.headerExpressions.size());
        for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.headerExpressions.entrySet()) {
            String header = entry.getKey();
            HeaderValueMessageProcessor<?> valueProcessor = entry.getValue();
            Boolean overwrite = valueProcessor.isOverwrite();
            overwrite = overwrite != null ? overwrite : true;
            if (!overwrite.booleanValue() && requestMessage.getHeaders().containsKey((Object)header)) continue;
            Object value = valueProcessor.processMessage(replyMessage);
            targetHeaders.put(header, value);
        }
        return this.getMessageBuilderFactory().withPayload(targetPayload).copyHeaders(targetHeaders).build();
    }

    public void start() {
        if (this.gateway != null) {
            this.gateway.start();
        }
    }

    public void stop() {
        if (this.gateway != null) {
            this.gateway.stop();
        }
    }

    public boolean isRunning() {
        return this.gateway == null || this.gateway.isRunning();
    }

    private static final class Gateway
    extends MessagingGatewaySupport {
        private Gateway() {
        }

        @Override
        protected Message<?> sendAndReceiveMessage(Object object) {
            return super.sendAndReceiveMessage(object);
        }

        @Override
        public String getComponentType() {
            return "enricher$gateway";
        }
    }
}

