/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.springframework.integration.util.CloseableIterator;
import org.springframework.integration.util.Function;

public final class FunctionIterator<T, V>
implements CloseableIterator<V> {
    private final Iterator<T> iterator;
    private final Function<? super T, ? extends V> function;

    public FunctionIterator(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        this(iterable.iterator(), function);
    }

    public FunctionIterator(Iterator<T> newIterator, Function<? super T, ? extends V> function) {
        this.iterator = newIterator;
        this.function = function;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a collect iterator");
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public V next() {
        return this.function.apply(this.iterator.next());
    }

    @Override
    public void close() throws IOException {
        if (this.iterator instanceof Closeable) {
            ((Closeable)((Object)this.iterator)).close();
        }
    }
}

