/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.converters;

import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.stereotype.Component;

@Component
public class BooleanConverter
implements Converter<Boolean> {
    @Override
    public Boolean convertFromText(String value, Class<?> requiredType, String optionContext) {
        if ("true".equalsIgnoreCase(value) || "1".equals(value) || "yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "0".equals(value) || "no".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to type Boolean.");
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> requiredType, String existingData, String optionContext, MethodTarget target) {
        completions.add(new Completion("true"));
        completions.add(new Completion("false"));
        completions.add(new Completion("yes"));
        completions.add(new Completion("no"));
        completions.add(new Completion("1"));
        completions.add(new Completion("0"));
        return false;
    }

    @Override
    public boolean supports(Class<?> requiredType, String optionContext) {
        return Boolean.class.isAssignableFrom(requiredType) || Boolean.TYPE.isAssignableFrom(requiredType);
    }
}

