/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.wrapper.BootstrapMainStarter;
import org.apache.maven.wrapper.DefaultDownloader;
import org.apache.maven.wrapper.Installer;
import org.apache.maven.wrapper.PathAssembler;
import org.apache.maven.wrapper.SystemPropertiesHandler;
import org.apache.maven.wrapper.WrapperExecutor;
import org.apache.maven.wrapper.cli.CommandLineParser;
import org.apache.maven.wrapper.cli.SystemPropertiesCommandLineConverter;

public class MavenWrapperMain {
    public static final String DEFAULT_MAVEN_USER_HOME = System.getProperty("user.home") + "/.m2";
    public static final String MAVEN_PROPERTIES_FILENAME = "maven.properties";
    public static final String MAVEN_USER_HOME_PROPERTY_KEY = "maven.user.home";
    public static final String MAVEN_USER_HOME_ENV_KEY = "MAVEN_USER_HOME";

    public static void main(String[] args) throws Exception {
        File wrapperJar = MavenWrapperMain.wrapperJar();
        File propertiesFile = MavenWrapperMain.wrapperProperties(wrapperJar);
        File rootDir = MavenWrapperMain.rootDir(wrapperJar);
        Properties systemProperties = System.getProperties();
        systemProperties.putAll(MavenWrapperMain.parseSystemPropertiesFromArgs(args));
        MavenWrapperMain.addSystemProperties(rootDir);
        WrapperExecutor wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile(propertiesFile, System.out);
        wrapperExecutor.execute(args, new Installer(new DefaultDownloader("mvnw", MavenWrapperMain.wrapperVersion()), new PathAssembler(MavenWrapperMain.mavenUserHome())), new BootstrapMainStarter());
    }

    private static Map<String, String> parseSystemPropertiesFromArgs(String[] args) {
        SystemPropertiesCommandLineConverter converter = new SystemPropertiesCommandLineConverter();
        CommandLineParser commandLineParser = new CommandLineParser();
        converter.configure(commandLineParser);
        commandLineParser.allowUnknownOptions();
        return (Map)converter.convert(commandLineParser.parse(args));
    }

    private static void addSystemProperties(File rootDir) {
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(new File(MavenWrapperMain.mavenUserHome(), MAVEN_PROPERTIES_FILENAME)));
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(new File(rootDir, MAVEN_PROPERTIES_FILENAME)));
    }

    private static File rootDir(File wrapperJar) {
        return wrapperJar.getParentFile().getParentFile();
    }

    private static File wrapperProperties(File wrapperJar) {
        return new File(wrapperJar.getParent(), wrapperJar.getName().replaceFirst("\\.jar$", ".properties"));
    }

    private static File wrapperJar() {
        URI location;
        try {
            location = MavenWrapperMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new RuntimeException(String.format("Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        return new File(location.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String wrapperVersion() {
        String string;
        InputStream resourceAsStream = MavenWrapperMain.class.getResourceAsStream("/META-INF/maven/com.rimerosolutions.maven.plugins/wrapper-maven-plugin/pom.properties");
        if (resourceAsStream == null) {
            throw new RuntimeException("No maven properties found.");
        }
        Properties mavenProperties = new Properties();
        try {
            mavenProperties.load(resourceAsStream);
            String version = mavenProperties.getProperty("version");
            if (version == null) {
                throw new RuntimeException("No version number specified in build receipt resource.");
            }
            string = version;
        }
        catch (Throwable throwable) {
            try {
                resourceAsStream.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not determine wrapper version.", e);
            }
        }
        resourceAsStream.close();
        return string;
    }

    private static File mavenUserHome() {
        String mavenUserHome = System.getProperty(MAVEN_USER_HOME_PROPERTY_KEY);
        if (mavenUserHome != null) {
            return new File(mavenUserHome);
        }
        mavenUserHome = System.getenv(MAVEN_USER_HOME_ENV_KEY);
        if (mavenUserHome != null) {
            return new File(mavenUserHome);
        }
        return new File(DEFAULT_MAVEN_USER_HOME);
    }
}

