/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.mybatis.generator.api.dom.OutputUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializationBlock {
    private boolean isStatic;
    private List<String> bodyLines;
    private List<String> javaDocLines;

    public InitializationBlock() {
        this(false);
    }

    public InitializationBlock(boolean isStatic) {
        this.isStatic = isStatic;
        this.bodyLines = new ArrayList<String>();
        this.javaDocLines = new ArrayList<String>();
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public List<String> getBodyLines() {
        return this.bodyLines;
    }

    public void addBodyLine(String line) {
        this.bodyLines.add(line);
    }

    public void addBodyLine(int index, String line) {
        this.bodyLines.add(index, line);
    }

    public void addBodyLines(Collection<String> lines) {
        this.bodyLines.addAll(lines);
    }

    public void addBodyLines(int index, Collection<String> lines) {
        this.bodyLines.addAll(index, lines);
    }

    public List<String> getJavaDocLines() {
        return this.javaDocLines;
    }

    public void addJavaDocLine(String javaDocLine) {
        this.javaDocLines.add(javaDocLine);
    }

    public String getFormattedContent(int indentLevel) {
        StringBuilder sb = new StringBuilder();
        for (String javaDocLine : this.javaDocLines) {
            OutputUtilities.javaIndent(sb, indentLevel);
            sb.append(javaDocLine);
            OutputUtilities.newLine(sb);
        }
        OutputUtilities.javaIndent(sb, indentLevel);
        if (this.isStatic) {
            sb.append("static ");
        }
        sb.append('{');
        ++indentLevel;
        ListIterator<String> listIter = this.bodyLines.listIterator();
        while (listIter.hasNext()) {
            String line = listIter.next();
            if (line.startsWith("}")) {
                --indentLevel;
            }
            OutputUtilities.newLine(sb);
            OutputUtilities.javaIndent(sb, indentLevel);
            sb.append(line);
            if (line.endsWith("{") && !line.startsWith("switch") || line.endsWith(":")) {
                ++indentLevel;
            }
            if (!line.startsWith("break")) continue;
            if (listIter.hasNext()) {
                String nextLine = listIter.next();
                if (nextLine.startsWith("}")) {
                    ++indentLevel;
                }
                listIter.previous();
            }
            --indentLevel;
        }
        OutputUtilities.newLine(sb);
        OutputUtilities.javaIndent(sb, --indentLevel);
        sb.append('}');
        return sb.toString();
    }
}

