/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.xml;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElement
extends Element {
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<Element> elements;
    private String name;

    public XmlElement(String name) {
        this.elements = new ArrayList<Element>();
        this.name = name;
    }

    public XmlElement(XmlElement original) {
        this.attributes.addAll(original.attributes);
        this.elements = new ArrayList<Element>();
        this.elements.addAll(original.elements);
        this.name = original.name;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public void addElement(Element element) {
        this.elements.add(element);
    }

    public void addElement(int index, Element element) {
        this.elements.add(index, element);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getFormattedContent(int indentLevel) {
        StringBuilder sb = new StringBuilder();
        OutputUtilities.xmlIndent(sb, indentLevel);
        sb.append('<');
        sb.append(this.name);
        for (Attribute att : this.attributes) {
            sb.append(' ');
            sb.append(att.getFormattedContent());
        }
        if (this.elements.size() > 0) {
            sb.append(" >");
            for (Element element : this.elements) {
                OutputUtilities.newLine(sb);
                sb.append(element.getFormattedContent(indentLevel + 1));
            }
            OutputUtilities.newLine(sb);
            OutputUtilities.xmlIndent(sb, indentLevel);
            sb.append("</");
            sb.append(this.name);
            sb.append('>');
        } else {
            sb.append(" />");
        }
        return sb.toString();
    }

    public void setName(String name) {
        this.name = name;
    }
}

