/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.ibatis2.dao.elements;

import org.mybatis.generator.api.DAOMethodNameCalculator;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.templates.AbstractDAOTemplate;
import org.mybatis.generator.internal.DefaultDAOMethodNameCalculator;
import org.mybatis.generator.internal.ExtendedDAOMethodNameCalculator;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public abstract class AbstractDAOElementGenerator
extends AbstractGenerator {
    protected AbstractDAOTemplate daoTemplate;
    private DAOMethodNameCalculator dAOMethodNameCalculator;
    private JavaVisibility exampleMethodVisibility;

    public abstract void addInterfaceElements(Interface var1);

    public abstract void addImplementationElements(TopLevelClass var1);

    public void setDAOTemplate(AbstractDAOTemplate abstractDAOTemplate) {
        this.daoTemplate = abstractDAOTemplate;
    }

    public DAOMethodNameCalculator getDAOMethodNameCalculator() {
        if (this.dAOMethodNameCalculator == null) {
            String type = this.context.getJavaClientGeneratorConfiguration().getProperty("methodNameCalculator");
            if (StringUtility.stringHasValue(type)) {
                if ("extended".equalsIgnoreCase(type)) {
                    type = ExtendedDAOMethodNameCalculator.class.getName();
                } else if ("default".equalsIgnoreCase(type)) {
                    type = DefaultDAOMethodNameCalculator.class.getName();
                }
            } else {
                type = DefaultDAOMethodNameCalculator.class.getName();
            }
            try {
                this.dAOMethodNameCalculator = (DAOMethodNameCalculator)ObjectFactory.createInternalObject(type);
            }
            catch (Exception e) {
                this.dAOMethodNameCalculator = new DefaultDAOMethodNameCalculator();
                this.warnings.add(Messages.getString("Warning.17", type, e.getMessage()));
            }
        }
        return this.dAOMethodNameCalculator;
    }

    public JavaVisibility getExampleMethodVisibility() {
        if (this.exampleMethodVisibility == null) {
            String type = this.context.getJavaClientGeneratorConfiguration().getProperty("exampleMethodVisibility");
            if (StringUtility.stringHasValue(type)) {
                if ("public".equalsIgnoreCase(type)) {
                    this.exampleMethodVisibility = JavaVisibility.PUBLIC;
                } else if ("private".equalsIgnoreCase(type)) {
                    this.exampleMethodVisibility = JavaVisibility.PRIVATE;
                } else if ("protected".equalsIgnoreCase(type)) {
                    this.exampleMethodVisibility = JavaVisibility.PROTECTED;
                } else if ("default".equalsIgnoreCase(type)) {
                    this.exampleMethodVisibility = JavaVisibility.DEFAULT;
                } else {
                    this.exampleMethodVisibility = JavaVisibility.PUBLIC;
                    this.warnings.add(Messages.getString("Warning.16", type));
                }
            } else {
                this.exampleMethodVisibility = JavaVisibility.PUBLIC;
            }
        }
        return this.exampleMethodVisibility;
    }
}

