/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.gateway.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dgtis.common.core.domain.R;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Order(value=-1)
@Configuration
public class GatewayExceptionHandler
implements ErrorWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GatewayExceptionHandler.class);

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        String msg;
        ServerHttpResponse response = exchange.getResponse();
        if (exchange.getResponse().isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        if (ex instanceof NotFoundException) {
            msg = "\u670d\u52a1\u672a\u627e\u5230";
        } else if (ex instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)ex;
            msg = responseStatusException.getMessage();
        } else {
            msg = "\u5185\u90e8\u670d\u52a1\u5668\u9519\u8bef";
        }
        log.error("[\u7f51\u5173\u5f02\u5e38\u5904\u7406]\u8bf7\u6c42\u8def\u5f84:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)exchange.getRequest().getPath(), (Object)ex.getMessage());
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        response.setStatusCode(HttpStatus.OK);
        return response.writeWith((Publisher)Mono.fromSupplier(() -> {
            DataBufferFactory bufferFactory = response.bufferFactory();
            return bufferFactory.wrap(JSON.toJSONBytes((Object)R.fail((String)msg), (SerializerFeature[])new SerializerFeature[0]));
        }));
    }
}

