/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.service.impl;

import com.dgtis.system.api.domain.SysUser;
import com.dgtis.system.service.ISysMenuService;
import com.dgtis.system.service.ISysPermissionService;
import com.dgtis.system.service.ISysRoleService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionServiceImpl
implements ISysPermissionService {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysMenuService menuService;

    public Set<String> getRolePermission(Long userId) {
        HashSet<String> roles = new HashSet<String>();
        if (SysUser.isAdmin((Long)userId)) {
            roles.add("admin");
        } else {
            roles.addAll(this.roleService.selectRolePermissionByUserId(userId));
        }
        return roles;
    }

    public Set<String> getMenuPermission(Long userId) {
        HashSet<String> perms = new HashSet<String>();
        if (SysUser.isAdmin((Long)userId)) {
            perms.add("*:*:*");
        } else {
            perms.addAll(this.menuService.selectMenuPermsByUserId(userId));
        }
        return perms;
    }
}

