/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.data.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dgtis.common.core.utils.DateUtils;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.core.utils.poi.CsvUtil;
import com.dgtis.common.core.web.domain.AjaxResult;
import com.dgtis.common.security.utils.SecurityUtils;
import com.dgtis.data.domain.Customer;
import com.dgtis.data.service.ISysUserService;
import com.dgtis.data.util.AddressResolutionUtil;
import com.dgtis.system.api.domain.SysUser;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/customer"})
public class CustomerApiController {
    private static Logger logger = LoggerFactory.getLogger(CustomerApiController.class);
    @Autowired
    private RestClient restClient;
    @Autowired
    private ISysUserService userService;

    @GetMapping(value={"/getCustomerList"})
    @ResponseBody
    public AjaxResult getCustomerList(@RequestParam(defaultValue="1") int pageNum, @RequestParam(defaultValue="10") int pageSize, String education, String policybelong, String payS, String payE, String fadate, String productname, String insuredAmountS, String insuredAmountE, String ageS, String ageE, String gender, String sobirth, String NOVPolicy, String custtype, String SCustID, String custclass, String participantsDateS, String participantsDateE, String PIncomeS, String PIncomeE, String Insured, String lp, String yx, String gzgw, String zcgw, String name, String idcard, String mobile) {
        try {
            int bYear;
            String year;
            Long userId = SecurityUtils.getUserId();
            SysUser sysUser = this.userService.selectUserById(userId);
            String deptCode = null;
            if (StringUtils.isNotEmpty((String)sysUser.getDept().getDeptCode()) && !"0".equals(sysUser.getDept().getDeptCode())) {
                deptCode = sysUser.getDept().getDeptCode();
            }
            logger.info("\u8fdb\u5ba2\u6237\u5217\u8868\u65f6\u95f4\uff1a" + DateUtils.getTime());
            String beginBirthDay = "";
            String endBirthDay = "";
            if (StringUtils.isNotEmpty((String)ageS)) {
                year = DateUtils.getYYYY();
                bYear = Integer.parseInt(year) - Integer.parseInt(ageS);
                endBirthDay = bYear + "-" + DateUtils.getMMDD();
            }
            if (StringUtils.isNotEmpty((String)ageE)) {
                year = DateUtils.getYYYY();
                bYear = Integer.parseInt(year) - Integer.parseInt(ageE);
                beginBirthDay = bYear + "-" + DateUtils.getMMDD();
            }
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            builder.append("\"query\":{");
            builder.append("\"bool\":{");
            builder.append("\"must\":[");
            if (StringUtils.isNotEmpty((String)policybelong)) {
                builder.append("{\"prefix\":{\"policybelong\":\"" + policybelong + "\"}},");
            }
            if (StringUtils.isNotEmpty((String)name)) {
                builder.append("{\"wildcard\":{\"name\":\"*" + name + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)mobile)) {
                builder.append("{\"wildcard\":{\"pmphone\":\"*" + mobile + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)fadate)) {
                builder.append("{\"wildcard\":{\"fadate\":\"*" + fadate + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)gender)) {
                builder.append("{\"prefix\":{\"gender\":" + gender + "}},");
            }
            if (StringUtils.isNotEmpty((String)NOVPolicy)) {
                builder.append("{\"prefix\":{\"label25\":\"" + NOVPolicy + "\"}},");
            }
            if (StringUtils.isNotEmpty((String)custclass)) {
                builder.append("{\"term\":{\"custclass\":\"" + custclass + "\"}},");
            }
            if (StringUtils.isNotEmpty((String)sobirth)) {
                builder.append("{\"wildcard\":{\"sobirth\":\"*" + sobirth + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)SCustID)) {
                builder.append("{\"wildcard\":{\"scustid\":\"*" + SCustID + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)custtype)) {
                builder.append("{\"wildcard\":{\"custtype\":\"*" + custtype + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)beginBirthDay) && StringUtils.isNotEmpty((String)endBirthDay)) {
                builder.append("{\"range\":{\"birthday\":{\"gte\":\"" + beginBirthDay + "\",\"lte\":\"" + endBirthDay + "\"}}},");
            } else {
                if (StringUtils.isNotEmpty((String)beginBirthDay)) {
                    builder.append("{\"range\":{\"birthday\":{\"gte\":\"" + beginBirthDay + "\"}}},");
                }
                if (StringUtils.isNotEmpty((String)endBirthDay)) {
                    builder.append("{\"range\":{\"birthday\":{\"lte\":\"" + endBirthDay + "\"}}},");
                }
            }
            if (StringUtils.isNotEmpty((String)participantsDateS) && StringUtils.isNotEmpty((String)participantsDateE)) {
                builder.append("{\"range\":{\"fadate\":{\"gte\":\"" + participantsDateS + "\",\"lte\":\"" + participantsDateE + "\"}}},");
            } else {
                if (StringUtils.isNotEmpty((String)participantsDateS)) {
                    builder.append("{\"range\":{\"fadate\":{\"gte\":\"" + participantsDateS + "\"}}},");
                }
                if (StringUtils.isNotEmpty((String)participantsDateE)) {
                    builder.append("{\"range\":{\"fadate\":{\"lte\":\"" + participantsDateE + "\"}}},");
                }
            }
            if (StringUtils.isNotEmpty((String)PIncomeS) && StringUtils.isNotEmpty((String)PIncomeE)) {
                builder.append("{\"range\":{\"pincome\":{\"gte\":\"" + PIncomeS + "\",\"lte\":\"" + PIncomeE + "\"}}},");
            } else {
                if (StringUtils.isNotEmpty((String)PIncomeS)) {
                    builder.append("{\"range\":{\"pincome\":{\"gte\":\"" + PIncomeS + "\"}}},");
                }
                if (StringUtils.isNotEmpty((String)PIncomeE)) {
                    builder.append("{\"range\":{\"pincome\":{\"lte\":\"" + PIncomeE + "\"}}},");
                }
            }
            if (StringUtils.isNotEmpty((String)yx)) {
                if (yx.equals("0")) {
                    builder.append("{\"range\":{\"novpolicy\":{\"gt\":\"" + yx + "\"}}},");
                } else {
                    builder.append("{\"prefix\":{\"label91\":\"\u5931\u6548\u5ba2\u6237\"}},");
                }
            }
            if (StringUtils.isNotEmpty((String)education)) {
                String[] edus = education.split("&");
                builder.append("{\"terms\":{\"education\":[");
                for (String edu : edus) {
                    builder.append("\"" + edu + "\",");
                }
                builder.delete(builder.length() - 1, builder.length());
                builder.append("]}},");
            }
            if (StringUtils.isNotEmpty((String)gzgw) && "0".equals(gzgw)) {
                builder.append("{\"prefix\":{\"label73\":\"\u5173\u6ce8\u5b98\u5fae\"}},");
            }
            if (StringUtils.isNotEmpty((String)zcgw) && "0".equals(zcgw)) {
                builder.append("{\"prefix\":{\"label74\":\"\u6ce8\u518c\u5b98\u5fae\"}},");
            }
            if (StringUtils.isNotEmpty((String)lp) && "0".equals(lp)) {
                builder.append("{\"prefix\":{\"label57\":\"\u6700\u8fd1\u4e00\u6b21\u7406\u8d54\u7c7b\u578b\"}},");
            }
            if (StringUtils.isNotEmpty((String)gender) || StringUtils.isNotEmpty((String)NOVPolicy) || StringUtils.isNotEmpty((String)custtype) || StringUtils.isNotEmpty((String)custclass) || StringUtils.isNotEmpty((String)sobirth) || StringUtils.isNotEmpty((String)SCustID) || StringUtils.isNotEmpty((String)beginBirthDay) || StringUtils.isNotEmpty((String)endBirthDay) || StringUtils.isNotEmpty((String)education) || StringUtils.isNotEmpty((String)PIncomeS) || StringUtils.isNotEmpty((String)PIncomeE) || StringUtils.isNotEmpty((String)gzgw) && "0".equals(gzgw) || StringUtils.isNotEmpty((String)zcgw) && "0".equals(zcgw) || StringUtils.isNotEmpty((String)yx) || StringUtils.isNotEmpty((String)lp) && "0".equals(lp) || StringUtils.isNotEmpty((String)participantsDateS) || StringUtils.isNotEmpty((String)participantsDateE) || StringUtils.isNotEmpty((String)policybelong) || StringUtils.isNotEmpty((String)name) || StringUtils.isNotEmpty((String)mobile) || StringUtils.isNotEmpty((String)fadate)) {
                builder.delete(builder.length() - 1, builder.length());
            }
            builder.append("],");
            builder.append("\"must_not\":[");
            if (StringUtils.isNotEmpty((String)gzgw) && "1".equals(gzgw)) {
                builder.append("{\"prefix\":{\"label73\":\"\u5173\u6ce8\u5b98\u5fae\"}},");
            }
            if (StringUtils.isNotEmpty((String)zcgw) && "1".equals(zcgw)) {
                builder.append("{\"prefix\":{\"label74\":\"\u6ce8\u518c\u5b98\u5fae\"}},");
            }
            if (StringUtils.isNotEmpty((String)lp) && "1".equals(lp)) {
                builder.append("{\"prefix\":{\"label57\":\"\u6700\u8fd1\u4e00\u6b21\u7406\u8d54\u7c7b\u578b\"}},");
            }
            if (StringUtils.isNotEmpty((String)gzgw) && "1".equals(gzgw) || StringUtils.isNotEmpty((String)zcgw) && "1".equals(zcgw) || StringUtils.isNotEmpty((String)lp) && "1".equals(lp)) {
                builder.delete(builder.length() - 1, builder.length());
            }
            builder.append("],");
            builder.append("\"should\":[");
            if (StringUtils.isNotEmpty((String)deptCode)) {
                builder.append("{\"wildcard\":{\"salecom\":\"*" + deptCode + "*\"}}");
            }
            if (StringUtils.isNotEmpty((String)idcard)) {
                builder.append("{\"wildcard\":{\"idcard\":\"*" + idcard + "*\"}},");
                builder.append("{\"wildcard\":{\"passport\":\"*" + idcard + "*\"}},");
                builder.append("{\"wildcard\":{\"dlicense\":\"*" + idcard + "*\"}},");
                builder.append("{\"wildcard\":{\"otheridnumber\":\"*" + idcard + "*\"}},");
                builder.delete(builder.length() - 1, builder.length());
            }
            builder.append("]");
            builder.append("}");
            builder.append("},");
            builder.append("\"from\":" + (pageNum - 1) * 10 + ",");
            builder.append("\"size\":" + pageSize + ",");
            builder.append("\"sort\":[{\"scustid\":{\"order\":\"asc\"}}],");
            builder.append("\"aggs\":{}");
            builder.append("}");
            logger.info(builder.toString());
            NStringEntity entity = new NStringEntity(builder.toString(), ContentType.APPLICATION_JSON);
            String url = "/shanglifeecif.individual/_search?pretty=true";
            Request scriptRequest = new Request("GET", url);
            scriptRequest.setEntity((HttpEntity)entity);
            Response response = this.restClient.performRequest(scriptRequest);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONObject hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            JSONArray array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList listMap = new ArrayList();
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = (JSONObject)array.get(i);
                HashMap<String, Object> mp = new HashMap<String, Object>();
                mp.put("id", json.getString("_id"));
                JSONObject jsonOb = JSON.parseObject((String)json.getString("_source"));
                mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                if (mp.containsKey("birthday")) {
                    mp.put("birthday", jsonOb.getString("birthday"));
                    mp.put("age", DateUtils.getAge((Date)DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)jsonOb.getString("birthday"))));
                } else {
                    mp.put("birthday", "");
                    mp.put("age", "");
                }
                listMap.add(mp);
            }
            long total = hitsobject.getLong("total");
            map.put("list", listMap);
            map.put("total", Long.valueOf(total));
            logger.info("\u51fa\u5ba2\u6237\u5217\u8868\u65f6\u95f4\uff1a" + DateUtils.getTime());
            return AjaxResult.success(map);
        }
        catch (Exception e) {
            logger.info("\u5217\u8868\u62a5\u9519\u65f6\u95f4\uff1a" + DateUtils.getTime());
            e.printStackTrace();
            return AjaxResult.error();
        }
    }

    @GetMapping(value={"/getCustomerById"})
    @ResponseBody
    public AjaxResult getCustomerById(String id) {
        try {
            String qSearch;
            Long userId = SecurityUtils.getUserId();
            SysUser sysUser = this.userService.selectUserById(userId);
            String deptCode = "";
            if (StringUtils.isNotEmpty((String)sysUser.getDept().getDeptCode()) && !"0".equals(sysUser.getDept().getDeptCode())) {
                deptCode = sysUser.getDept().getDeptCode();
            }
            logger.info("\u8fdb\u5ba2\u6237\u8be6\u60c5\u65f6\u95f4\uff1a" + DateUtils.getTime());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("pretty", "true");
            Request scriptRequest = new Request("GET", "/shanglifeecif.individual/default_type_/" + id + "?pretty=true");
            Response response = this.restClient.performRequest(scriptRequest);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            HashMap<String, Object> map = new HashMap<String, Object>();
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONObject source = JSON.parseObject((String)jsonObject.getString("_source"));
            String indid = jsonObject.getString("_id");
            String custtype = source.getString("custtype");
            String scustid = source.getString("scustid");
            Map mpInfo = this.getLables(jsonObject, deptCode);
            map.put("custInfo", mpInfo);
            HashMap<String, String> query = new HashMap<String, String>();
            query.put("indid1", indid);
            scriptRequest = new Request("GET", "/shanglifeecif.indrelationship/_search?pretty=true&q=indid1:" + scustid);
            response = this.restClient.performRequest(scriptRequest);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            jsonObject = JSON.parseObject((String)result);
            JSONObject hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            JSONArray array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList relationship = new ArrayList();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = (JSONObject)array.get(i);
                HashMap<String, String> mp = new HashMap<String, String>();
                mp.put("id", json.getString("_id"));
                mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                relationship.add(mp);
            }
            map.put("relationship", relationship);
            query = new HashMap();
            query.put("applicantid", indid);
            String lpqSearch = "lpscutid:" + scustid;
            if (StringUtils.isNotEmpty((String)deptCode)) {
                lpqSearch = "(lpscutid:" + scustid + "%20AND%20salecom:" + deptCode + ")";
            }
            scriptRequest = new Request("GET", "/shanglifeecif.insuranceclaimthread/_search?size=100&pretty=true&q=" + lpqSearch);
            response = this.restClient.performRequest(scriptRequest);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            jsonObject = JSON.parseObject((String)result);
            hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList insuranceclaimthread = new ArrayList();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = (JSONObject)array.get(i);
                HashMap<String, String> mp = new HashMap<String, String>();
                mp.put("id", json.getString("_id"));
                mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                insuranceclaimthread.add(mp);
            }
            map.put("insuranceclaimthread", insuranceclaimthread);
            if ("\u88ab\u4fdd\u4eba".equals(custtype.trim())) {
                qSearch = "insuredscustid:" + scustid;
                if (StringUtils.isNotEmpty((String)deptCode)) {
                    qSearch = "(insuredscustid:" + scustid + "%20AND%20policybelong:" + deptCode + ")";
                }
                scriptRequest = new Request("GET", "/shanglifeecif.insurancearrangement/_search?size=100&pretty=true&sort=padate:asc&q=" + qSearch);
            } else {
                qSearch = "applicantscustid:" + scustid;
                if (StringUtils.isNotEmpty((String)deptCode)) {
                    qSearch = "(applicantscustid:" + scustid + "%20AND%20policybelong:" + deptCode + ")";
                }
                scriptRequest = new Request("GET", "/shanglifeecif.insurancearrangement/_search?size=100&pretty=true&sort=padate:asc&q=" + qSearch);
            }
            logger.info("\u5408\u7ea6\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570" + scriptRequest.getEndpoint());
            response = this.restClient.performRequest(scriptRequest);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            jsonObject = JSON.parseObject((String)result);
            hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList insurancearrangement = new ArrayList();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = (JSONObject)array.get(i);
                HashMap<String, String> mp = new HashMap<String, String>();
                mp.put("id", json.getString("_id"));
                mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                insurancearrangement.add(mp);
            }
            map.put("insurancearrangement", insurancearrangement);
            String jcqSearch = "partyid:" + scustid;
            if (StringUtils.isNotEmpty((String)deptCode)) {
                jcqSearch = "(partyid:" + scustid + "%20AND%20salecom:" + deptCode + ")";
            }
            scriptRequest = new Request("GET", "/shanglifeecif.partytimeline/_search?size=100&pretty=true&sort=sdate:asc&q=" + jcqSearch);
            logger.info("\u63a5\u89e6\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570:", (Object)scriptRequest.getEndpoint());
            response = this.restClient.performRequest(scriptRequest);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            jsonObject = JSON.parseObject((String)result);
            hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList partytimeline = new ArrayList();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = (JSONObject)array.get(i);
                HashMap<String, String> mp = new HashMap<String, String>();
                mp.put("id", json.getString("_id"));
                mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                partytimeline.add(mp);
            }
            map.put("partytimeline", partytimeline);
            logger.info(scriptRequest.getEndpoint());
            logger.info("\u51fa\u5ba2\u6237\u8be6\u60c5\u65f6\u95f4\uff1a" + DateUtils.getTime());
            return AjaxResult.success(map);
        }
        catch (Exception e) {
            logger.info("\u5ba2\u6237\u8be6\u60c5\u62a5\u9519\u65f6\u95f4\uff1a" + DateUtils.getTime());
            e.printStackTrace();
            return AjaxResult.error();
        }
    }

    @GetMapping(value={"/getCustomerOverViewById"})
    @ResponseBody
    public AjaxResult getCustomerOverViewById(String id) {
        Long userId = SecurityUtils.getUserId();
        SysUser sysUser = this.userService.selectUserById(userId);
        String deptCode = null;
        if (StringUtils.isNotEmpty((String)sysUser.getDept().getDeptCode()) && !"0".equals(sysUser.getDept().getDeptCode())) {
            deptCode = sysUser.getDept().getDeptCode();
        }
        try {
            logger.info("\u8fdb\u5ba2\u6237\u6982\u89c8\u65f6\u95f4\uff1a" + DateUtils.getTime());
            Request scriptRequest = new Request("GET", "/shanglifeecif.individual/default_type_/" + id + "?pretty=true");
            Response response = this.restClient.performRequest(scriptRequest);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            HashMap<String, Map> map = new HashMap<String, Map>();
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONObject source = JSON.parseObject((String)jsonObject.getString("_source"));
            String scustid = source.getString("scustid");
            Map mpInfo = this.getLables(jsonObject, deptCode);
            String jcqSearch = "applicantscustid:" + scustid;
            if (StringUtils.isNotEmpty((String)deptCode)) {
                jcqSearch = "(applicantscustid:" + scustid + "%20AND%20policybelong:" + deptCode + ")";
            }
            scriptRequest = new Request("GET", "/shanglifeecif.insurancearrangement/_search?size=100&pretty=true&sort=padate:asc&q=" + jcqSearch);
            logger.info("insurancearrangement", (Object)scriptRequest.getEndpoint());
            response = this.restClient.performRequest(scriptRequest);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            jsonObject = JSON.parseObject((String)result);
            JSONObject hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            JSONArray array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            DecimalFormat df = new DecimalFormat("######0.0");
            double prem = 0.0;
            double sumprem = 0.0;
            double handedinprem = 0.0;
            HashMap<String, Object> expectedData = new HashMap<String, Object>();
            String[] edata = new String[]{"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"};
            expectedData.put("name", "");
            HashMap<String, Object> actaulData = new HashMap<String, Object>();
            String[] adata = new String[]{"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"};
            actaulData.put("name", "");
            ArrayList<String> xaxisData = new ArrayList<String>();
            xaxisData.add("1");
            xaxisData.add("2");
            xaxisData.add("3");
            xaxisData.add("4");
            xaxisData.add("5");
            xaxisData.add("6");
            xaxisData.add("7");
            xaxisData.add("8");
            xaxisData.add("9");
            xaxisData.add("10");
            xaxisData.add("11");
            xaxisData.add("12");
            long insureDay = 0L;
            int guaranteeDay = 0;
            HashMap<String, Double> majorCategorie = new HashMap<String, Double>();
            HashMap<String, String> mpremMap = new HashMap<String, String>();
            int firstDate = 1;
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(1, 1);
            Date nextYearTime = cal.getTime();
            String currentDateTime = DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)date);
            String currentYear = DateUtils.parseDateToStr((String)DateUtils.YYYY, (Date)date);
            HashSet<String> noivpolicyset = new HashSet<String>();
            HashSet<String> novpolicyset = new HashSet<String>();
            logger.info("getCustomerOverViewById", (Object)array.toJSONString());
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = (JSONObject)array.get(i);
                JSONObject _source = (JSONObject)json.get((Object)"_source");
                Date padate = _source.getDate("padate");
                if (i == 0) {
                    insureDay = DateUtils.getDateDifDay((Date)new Date(), (Date)padate);
                }
                if ("\u6709\u6548".equals(_source.getString("policystate"))) {
                    String risk_categories_name;
                    Integer agrmntage;
                    novpolicyset.add(_source.getString("policyno"));
                    if (_source.containsKey((Object)"sumprem")) {
                        sumprem += _source.getDouble("sumprem").doubleValue();
                    }
                    if ((agrmntage = _source.getInteger("agrmntage")) < 180) {
                        Date pindate = _source.getDate("pindate");
                        Date pmdate = _source.getDate("pmdate");
                        guaranteeDay = (int)((long)guaranteeDay + DateUtils.getDateDifDay((Date)pmdate, (Date)pindate));
                    } else if (firstDate == 1) {
                        guaranteeDay = (int)((long)guaranteeDay + DateUtils.getDateDifDay((Date)new Date(), (Date)padate));
                        ++firstDate;
                    }
                    if (_source.containsKey((Object)"prem")) {
                        if (!"\u8db8\u7f34".equals(_source.getString("payment"))) {
                            String m;
                            String payendyear;
                            String norenewal = _source.getString("norenewal") == null ? "" : _source.getString("norenewal").trim();
                            String string = payendyear = _source.getString("payendyear") == null ? "" : _source.getString("payendyear").trim();
                            if (_source.containsKey((Object)"npdate")) {
                                Date npdate = _source.getDate("npdate");
                                String npDateStr = DateUtils.parseDateToStr((String)"yyyy-MM-dd", (Date)npdate);
                                String npDateStrYear = DateUtils.parseDateToStr((String)"yyyy", (Date)npdate);
                                if (!norenewal.equals(payendyear) || norenewal.equals(payendyear) && Integer.parseInt(npDateStrYear) - 1 == Integer.parseInt(currentYear)) {
                                    prem += _source.getDouble("prem").doubleValue();
                                    if (norenewal.equals(payendyear) && nextYearTime.getTime() > npdate.getTime() && Integer.parseInt(npDateStrYear) > Integer.parseInt(currentYear)) {
                                        handedinprem += _source.getDouble("prem").doubleValue();
                                    }
                                }
                                if (!norenewal.equals(payendyear) && npDateStr.compareTo(currentDateTime) > 0 && !npDateStrYear.equals(currentYear)) {
                                    handedinprem += _source.getDouble("prem").doubleValue();
                                }
                            }
                            if (mpremMap.containsKey(m = DateUtils.parseDateToStr((String)"M", (Date)padate))) {
                                double tprem = Double.parseDouble(mpremMap.get(m).toString());
                                mpremMap.put(m, df.format(tprem += _source.getDouble("prem").doubleValue()));
                                edata[Integer.parseInt((String)m) - 1] = df.format(tprem);
                                adata[Integer.parseInt((String)m) - 1] = df.format(tprem);
                            } else {
                                mpremMap.put(m, df.format(_source.getDouble("prem")));
                                edata[Integer.parseInt((String)m) - 1] = df.format(_source.getDouble("prem"));
                                adata[Integer.parseInt((String)m) - 1] = df.format(_source.getDouble("prem"));
                            }
                        } else if ("\u8db8\u7f34".equals(_source.getString("payment")) && currentYear.equals(DateUtils.parseDateToStr((String)"yyyy", (Date)padate))) {
                            prem += _source.getDouble("prem").doubleValue();
                            handedinprem += _source.getDouble("prem").doubleValue();
                        }
                    }
                    if (majorCategorie.containsKey(risk_categories_name = _source.getString("risk_categories_name"))) {
                        double risk = Double.parseDouble(majorCategorie.get(risk_categories_name).toString());
                        if (_source.containsKey((Object)"risk")) {
                            risk += _source.getDouble("risk").doubleValue();
                        }
                        majorCategorie.put(risk_categories_name, risk);
                        continue;
                    }
                    if (!_source.containsKey((Object)"risk") || !StringUtils.isNotEmpty((String)risk_categories_name)) continue;
                    majorCategorie.put(risk_categories_name, _source.getDouble("risk"));
                    continue;
                }
                if ("\u7ec8\u6b62".equals(_source.getString("policystate"))) {
                    Integer agrmntage;
                    String norenewal = _source.getString("norenewal") == null ? "" : _source.getString("norenewal").trim();
                    String payendyear = _source.getString("payendyear") == null ? "" : _source.getString("payendyear").trim();
                    Date pmdate = _source.getDate("pmdate");
                    if (norenewal.equals(payendyear) && currentDateTime.compareTo(DateUtils.parseDateToStr((String)DateUtils.YYYY_MM_DD, (Date)pmdate)) > 0 && _source.containsKey((Object)"sumprem")) {
                        sumprem += _source.getDouble("sumprem").doubleValue();
                    }
                    if ((agrmntage = _source.getInteger("agrmntage")) < 180) {
                        Date pindate = _source.getDate("pindate");
                        guaranteeDay = (int)((long)guaranteeDay + DateUtils.getDateDifDay((Date)pmdate, (Date)pindate));
                    }
                }
                if (_source.getString("policystate") == null) continue;
                noivpolicyset.add(_source.getString("policyno"));
            }
            mpInfo.put("noivpolicy", noivpolicyset.size());
            mpInfo.put("novpolicy", novpolicyset.size());
            expectedData.put("data", edata);
            actaulData.put("data", adata);
            HashMap<String, Cloneable> lineBarChartData = new HashMap<String, Cloneable>();
            lineBarChartData.put("expectedData", expectedData);
            lineBarChartData.put("actaulData", actaulData);
            lineBarChartData.put("xaxisData", xaxisData);
            map.put("lineBarChartData", lineBarChartData);
            String lpqSearch = "lpscutid:" + scustid;
            if (StringUtils.isNotEmpty((String)deptCode)) {
                lpqSearch = "(lpscutid:" + scustid + "%20AND%20salecom:" + deptCode + ")";
            }
            scriptRequest = new Request("GET", "/shanglifeecif.insuranceclaimthread/_search?size=100&pretty=true&q=" + lpqSearch);
            response = this.restClient.performRequest(scriptRequest);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            jsonObject = JSON.parseObject((String)result);
            hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            HashMap<String, String> insuranceclaimthread = new HashMap<String, String>();
            ArrayList<JSONObject> insuranceclaimthreads = new ArrayList<JSONObject>();
            double claimAmount = 0.0;
            HashSet<String> claimTypeSet = new HashSet<String>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = (JSONObject)array.get(i);
                JSONObject claimSource = JSON.parseObject((String)json.getString("_source"));
                if (claimSource.containsKey((Object)"ccamt")) {
                    claimAmount += claimSource.getDouble("ccamt").doubleValue();
                }
                claimTypeSet.add(claimSource.getString("accidenttype"));
                insuranceclaimthreads.add(claimSource);
            }
            insuranceclaimthread.put("isClaim", insuranceclaimthreads.size() > 0 ? "\u662f" : "\u5426");
            insuranceclaimthread.put("claimAmount", df.format(claimAmount));
            insuranceclaimthread.put("claimType", String.join((CharSequence)",", claimTypeSet));
            map.put("insuranceclaimthread", insuranceclaimthread);
            mpInfo.put("prem", df.format(prem));
            mpInfo.put("sumprem", df.format(sumprem));
            mpInfo.put("handedinprem", df.format(handedinprem));
            mpInfo.put("insureDay", insureDay / 365L + "\u5e74" + insureDay % 365L + "\u5929");
            String tbcustomerinfoSearch = "scustid:" + scustid;
            if (StringUtils.isNotEmpty((String)deptCode)) {
                tbcustomerinfoSearch = "(scustid:" + scustid + "%20AND%20salecom:" + deptCode + ")";
            }
            scriptRequest = new Request("GET", "/shanglifeecif.tbcustomerinfo/_search?pretty=true&sort=sdate:asc&size=100&q=" + tbcustomerinfoSearch);
            response = this.restClient.performRequest(scriptRequest);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            jsonObject = JSON.parseObject((String)result);
            hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            Date fSdate = null;
            Date fEdate = null;
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = (JSONObject)array.get(i);
                JSONObject tbSource = JSON.parseObject((String)json.getString("_source"));
                if (!tbSource.containsKey((Object)"sdate") || !tbSource.containsKey((Object)"edate")) continue;
                Date sdate = tbSource.getDate("sdate");
                Date edate = tbSource.getDate("edate");
                if (i == 0) {
                    fSdate = sdate;
                    fEdate = edate;
                }
                if (i <= 0) continue;
                if (sdate.getTime() <= fEdate.getTime()) {
                    if (edate.getTime() > fEdate.getTime()) {
                        fEdate = edate;
                    }
                } else if (i != array.size()) {
                    guaranteeDay = (int)((long)guaranteeDay + DateUtils.getDateDifDay((Date)fEdate, (Date)fSdate));
                    fSdate = sdate;
                    fEdate = edate;
                }
                if (i != array.size() - 1) continue;
                guaranteeDay = (int)((long)guaranteeDay + DateUtils.getDateDifDay((Date)fEdate, (Date)fSdate));
            }
            mpInfo.put("guaranteeDay", (long)guaranteeDay > insureDay ? insureDay + "\u5929" : guaranteeDay + "\u5929");
            map.put("custInfo", mpInfo);
            HashMap<String, String> riskMap = new HashMap<String, String>();
            riskMap.put("\u4eba\u5bff\u4fdd\u9669", "0");
            riskMap.put("\u65b0\u578b\u5bff\u9669", "0");
            riskMap.put("\u610f\u5916\u4f24\u5bb3\u4fdd\u9669", "0");
            riskMap.put("\u533b\u7597\u9669", "0");
            riskMap.put("\u91cd\u75be\u4fdd\u9669", "0");
            riskMap.put("\u5e74\u91d1\u4fdd\u9669", "0");
            for (String key : majorCategorie.keySet()) {
                if (!riskMap.containsKey(key)) continue;
                riskMap.put(key, (String)majorCategorie.get(key));
            }
            map.put("majorCategorie", riskMap);
            logger.info("\u51fa\u5ba2\u6237\u6982\u89c8\u65f6\u95f4\uff1a" + DateUtils.getTime());
            return AjaxResult.success(map);
        }
        catch (Exception e) {
            logger.info("\u5ba2\u6237\u6982\u89c8\u62a5\u9519\u65f6\u95f4\uff1a" + DateUtils.getTime());
            e.printStackTrace();
            return AjaxResult.error();
        }
    }

    @GetMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, String education, String policybelong, String payS, String payE, String fadate, String productname, String insuredAmountS, String insuredAmountE, String ageS, String ageE, String gender, String sobirth, String NOVPolicy, String custtype, String SCustID, String custclass, String participantsDateS, String participantsDateE, String PIncomeS, String PIncomeE, String Insured, String lp, String yx, String gzgw, String zcgw, String name, String idcard, String mobile) {
        logger.info("\u5bfc\u51fa\u8fdb\u65f6\u95f4\uff1a" + DateUtils.getTime());
        try {
            int bYear;
            String year;
            Long userId = SecurityUtils.getUserId();
            SysUser sysUser = this.userService.selectUserById(userId);
            String deptCode = null;
            if (StringUtils.isNotEmpty((String)sysUser.getDept().getDeptCode()) && !"0".equals(sysUser.getDept().getDeptCode())) {
                deptCode = sysUser.getDept().getDeptCode();
            }
            String beginBirthDay = "";
            String endBirthDay = "";
            if (StringUtils.isNotEmpty((String)ageS)) {
                year = DateUtils.getYYYY();
                bYear = Integer.parseInt(year) - Integer.parseInt(ageS);
                endBirthDay = bYear + "-" + DateUtils.getMMDD();
            }
            if (StringUtils.isNotEmpty((String)ageE)) {
                year = DateUtils.getYYYY();
                bYear = Integer.parseInt(year) - Integer.parseInt(ageE);
                beginBirthDay = bYear + "-" + DateUtils.getMMDD();
            }
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            builder.append("\"query\":{");
            builder.append("\"bool\":{");
            builder.append("\"must\":[");
            if (StringUtils.isNotEmpty((String)policybelong)) {
                builder.append("{\"prefix\":{\"policybelong\":\"" + policybelong + "\"}},");
            }
            if (StringUtils.isNotEmpty((String)name)) {
                builder.append("{\"wildcard\":{\"name\":\"*" + name + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)mobile)) {
                builder.append("{\"wildcard\":{\"pmphone\":\"*" + mobile + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)fadate)) {
                builder.append("{\"wildcard\":{\"fadate\":\"*" + fadate + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)gender)) {
                builder.append("{\"prefix\":{\"gender\":" + gender + "}},");
            }
            if (StringUtils.isNotEmpty((String)NOVPolicy)) {
                builder.append("{\"prefix\":{\"label25\":\"" + NOVPolicy + "\"}},");
            }
            if (StringUtils.isNotEmpty((String)custclass)) {
                builder.append("{\"term\":{\"custclass\":\"" + custclass + "\"}},");
            }
            if (StringUtils.isNotEmpty((String)sobirth)) {
                builder.append("{\"wildcard\":{\"sobirth\":\"*" + sobirth + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)SCustID)) {
                builder.append("{\"wildcard\":{\"scustid\":\"*" + SCustID + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)custtype)) {
                builder.append("{\"wildcard\":{\"custtype\":\"*" + custtype + "*\"}},");
            }
            if (StringUtils.isNotEmpty((String)beginBirthDay) && StringUtils.isNotEmpty((String)endBirthDay)) {
                builder.append("{\"range\":{\"birthday\":{\"gte\":\"" + beginBirthDay + "\",\"lte\":\"" + endBirthDay + "\"}}},");
            } else {
                if (StringUtils.isNotEmpty((String)beginBirthDay)) {
                    builder.append("{\"range\":{\"birthday\":{\"gte\":\"" + beginBirthDay + "\"}}},");
                }
                if (StringUtils.isNotEmpty((String)endBirthDay)) {
                    builder.append("{\"range\":{\"birthday\":{\"lte\":\"" + endBirthDay + "\"}}},");
                }
            }
            if (StringUtils.isNotEmpty((String)participantsDateS) && StringUtils.isNotEmpty((String)participantsDateE)) {
                builder.append("{\"range\":{\"fadate\":{\"gte\":\"" + participantsDateS + "\",\"lte\":\"" + participantsDateE + "\"}}},");
            } else {
                if (StringUtils.isNotEmpty((String)participantsDateS)) {
                    builder.append("{\"range\":{\"fadate\":{\"gte\":\"" + participantsDateS + "\"}}},");
                }
                if (StringUtils.isNotEmpty((String)participantsDateE)) {
                    builder.append("{\"range\":{\"fadate\":{\"lte\":\"" + participantsDateE + "\"}}},");
                }
            }
            if (StringUtils.isNotEmpty((String)PIncomeS) && StringUtils.isNotEmpty((String)PIncomeE)) {
                builder.append("{\"range\":{\"pincome\":{\"gte\":\"" + PIncomeS + "\",\"lte\":\"" + PIncomeE + "\"}}},");
            } else {
                if (StringUtils.isNotEmpty((String)PIncomeS)) {
                    builder.append("{\"range\":{\"pincome\":{\"gte\":\"" + PIncomeS + "\"}}},");
                }
                if (StringUtils.isNotEmpty((String)PIncomeE)) {
                    builder.append("{\"range\":{\"pincome\":{\"lte\":\"" + PIncomeE + "\"}}},");
                }
            }
            if (StringUtils.isNotEmpty((String)yx)) {
                if (yx.equals("0")) {
                    builder.append("{\"range\":{\"novpolicy\":{\"gt\":\"" + yx + "\"}}},");
                } else {
                    builder.append("{\"prefix\":{\"label91\":\"\u5931\u6548\u5ba2\u6237\"}},");
                }
            }
            if (StringUtils.isNotEmpty((String)education)) {
                String[] edus = education.split("&");
                builder.append("{\"terms\":{\"education\":[");
                for (String edu : edus) {
                    builder.append("\"" + edu + "\",");
                }
                builder.delete(builder.length() - 1, builder.length());
                builder.append("]}},");
            }
            if (StringUtils.isNotEmpty((String)gzgw) && "0".equals(gzgw)) {
                builder.append("{\"prefix\":{\"label73\":\"\u5173\u6ce8\u5b98\u5fae\"}},");
            }
            if (StringUtils.isNotEmpty((String)zcgw) && "0".equals(zcgw)) {
                builder.append("{\"prefix\":{\"label74\":\"\u6ce8\u518c\u5b98\u5fae\"}},");
            }
            if (StringUtils.isNotEmpty((String)lp) && "0".equals(lp)) {
                builder.append("{\"prefix\":{\"label57\":\"\u6700\u8fd1\u4e00\u6b21\u7406\u8d54\u7c7b\u578b\"}},");
            }
            if (StringUtils.isNotEmpty((String)gender) || StringUtils.isNotEmpty((String)NOVPolicy) || StringUtils.isNotEmpty((String)custtype) || StringUtils.isNotEmpty((String)custclass) || StringUtils.isNotEmpty((String)sobirth) || StringUtils.isNotEmpty((String)SCustID) || StringUtils.isNotEmpty((String)beginBirthDay) || StringUtils.isNotEmpty((String)endBirthDay) || StringUtils.isNotEmpty((String)education) || StringUtils.isNotEmpty((String)PIncomeS) || StringUtils.isNotEmpty((String)PIncomeE) || StringUtils.isNotEmpty((String)gzgw) && "0".equals(gzgw) || StringUtils.isNotEmpty((String)zcgw) && "0".equals(zcgw) || StringUtils.isNotEmpty((String)yx) || StringUtils.isNotEmpty((String)lp) && "0".equals(lp) || StringUtils.isNotEmpty((String)participantsDateS) || StringUtils.isNotEmpty((String)participantsDateE) || StringUtils.isNotEmpty((String)policybelong) || StringUtils.isNotEmpty((String)name) || StringUtils.isNotEmpty((String)mobile) || StringUtils.isNotEmpty((String)fadate)) {
                builder.delete(builder.length() - 1, builder.length());
            }
            builder.append("],");
            builder.append("\"must_not\":[");
            if (StringUtils.isNotEmpty((String)gzgw) && "1".equals(gzgw)) {
                builder.append("{\"prefix\":{\"label73\":\"\u5173\u6ce8\u5b98\u5fae\"}},");
            }
            if (StringUtils.isNotEmpty((String)zcgw) && "1".equals(zcgw)) {
                builder.append("{\"prefix\":{\"label74\":\"\u6ce8\u518c\u5b98\u5fae\"}},");
            }
            if (StringUtils.isNotEmpty((String)lp) && "1".equals(lp)) {
                builder.append("{\"prefix\":{\"label57\":\"\u6700\u8fd1\u4e00\u6b21\u7406\u8d54\u7c7b\u578b\"}},");
            }
            if (StringUtils.isNotEmpty((String)gzgw) && "1".equals(gzgw) || StringUtils.isNotEmpty((String)zcgw) && "1".equals(zcgw) || StringUtils.isNotEmpty((String)lp) && "1".equals(lp)) {
                builder.delete(builder.length() - 1, builder.length());
            }
            builder.append("],");
            builder.append("\"should\":[");
            if (StringUtils.isNotEmpty((String)deptCode)) {
                builder.append("{\"wildcard\":{\"salecom\":\"*" + deptCode + "*\"}}");
            }
            if (StringUtils.isNotEmpty((String)idcard)) {
                builder.append("{\"wildcard\":{\"idcard\":\"*" + idcard + "*\"}},");
                builder.append("{\"wildcard\":{\"passport\":\"*" + idcard + "*\"}},");
                builder.append("{\"wildcard\":{\"dlicense\":\"*" + idcard + "*\"}},");
                builder.append("{\"wildcard\":{\"otheridnumber\":\"*" + idcard + "*\"}},");
                builder.delete(builder.length() - 1, builder.length());
            }
            builder.append("]");
            builder.append("}");
            builder.append("},");
            builder.append("\"from\":\"0\",");
            builder.append("\"size\":\"10000\",");
            builder.append("\"sort\":[{\"scustid\":{\"order\":\"asc\"}}],");
            builder.append("\"aggs\":{}");
            builder.append("}");
            NStringEntity entity = new NStringEntity(builder.toString(), ContentType.APPLICATION_JSON);
            String url = "/shanglifeecif.individual/_search?&scroll=5m";
            Request scriptRequest = new Request("GET", url);
            scriptRequest.setEntity((HttpEntity)entity);
            Response responseData = this.restClient.performRequest(scriptRequest);
            String result = EntityUtils.toString((HttpEntity)responseData.getEntity());
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONObject hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            JSONArray array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList<Customer> customers = new ArrayList<Customer>();
            String scroll_id = jsonObject.getString("_scroll_id");
            entity = new NStringEntity("{\n  \"scroll_id\": \"" + scroll_id + "\",\n  \"scroll\": \"5m\"\n}", ContentType.APPLICATION_JSON);
            while (array.size() != 0) {
                for (int i = 0; i < array.size(); ++i) {
                    List list;
                    JSONObject json = (JSONObject)array.get(i);
                    HashMap<String, Object> mp = new HashMap<String, Object>();
                    Customer customer = new Customer();
                    json.getString("_source");
                    mp.put("id", json.getString("_id"));
                    JSONObject jsonOb = JSON.parseObject((String)json.getString("_source"));
                    mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                    customer.setScustId("\t" + jsonOb.getString("scustid"));
                    customer.setCustId(jsonOb.getString("custid"));
                    customer.setName(jsonOb.getString("name"));
                    customer.setSex("0".equals(jsonOb.getString("gender")) ? "\u7537" : "\u5973");
                    customer.setCustType(jsonOb.getString("custtype"));
                    customer.setEducation(jsonOb.getString("education"));
                    customer.setVaild(StringUtils.isEmpty((String)jsonOb.getString("label91")) ? "\u6709\u6548" : "\u65e0\u6548");
                    customer.setpIncome(jsonOb.getString("pincome"));
                    customer.setNum(jsonOb.getString("label25"));
                    String ral = jsonOb.getString("ral");
                    if (StringUtils.isNotBlank((CharSequence)ral) && (list = AddressResolutionUtil.addressResolution((String)ral)) != null && list.size() > 0) {
                        customer.setProvince(((Map)list.get(0)).get("province").toString());
                    }
                    if (mp.containsKey("birthday")) {
                        String birthday = jsonOb.getString("birthday");
                        mp.put("birthday", birthday);
                        mp.put("age", DateUtils.getAge((Date)DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)birthday)));
                        customer.setBirthDay("\t" + birthday);
                        customer.setAge(DateUtils.getAge((Date)DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)birthday)));
                    }
                    if (mp.containsKey("idcard")) {
                        customer.setIdType("\u8eab\u4efd\u8bc1");
                        String idCard = jsonOb.getString("idcard");
                        if (idCard.length() > 6) {
                            customer.setIdCard("\t" + idCard.replaceAll(idCard.substring(idCard.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("passport")) {
                        customer.setIdType("\u62a4\u7167");
                        String passport = jsonOb.getString("passport");
                        if (passport.length() > 6) {
                            customer.setIdCard("\t" + passport.replaceAll(passport.substring(passport.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("dlicense")) {
                        customer.setIdType("\u9a7e\u9a76\u8bc1");
                        String dlicense = jsonOb.getString("dlicense");
                        if (dlicense.length() > 6) {
                            customer.setIdCard("\t" + dlicense.replaceAll(dlicense.substring(dlicense.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("otheridnumber")) {
                        customer.setIdType("\u5176\u5b83\u8bc1\u4ef6\u7c7b\u578b");
                        String otheridnumber = jsonOb.getString("otheridnumber");
                        if (otheridnumber.length() > 6) {
                            customer.setIdCard("\t" + otheridnumber.replaceAll(otheridnumber.substring(otheridnumber.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    }
                    if (mp.containsKey("custclass")) {
                        String custclazz;
                        switch (custclazz = jsonOb.getString("custclass")) {
                            case "1": {
                                customer.setCustClass("\u94bb\u77f3");
                                break;
                            }
                            case "2": {
                                customer.setCustClass("\u767d\u91d1");
                                break;
                            }
                            case "3": {
                                customer.setCustClass("\u9ec4\u91d1");
                                break;
                            }
                            case "4": {
                                customer.setCustClass("\u666e\u901a");
                                break;
                            }
                            default: {
                                customer.setCustClass("\u65e0");
                                break;
                            }
                        }
                    } else {
                        customer.setCustClass("\u65e0");
                    }
                    customers.add(customer);
                }
                scriptRequest = new Request("GET", "/_search/scroll");
                scriptRequest.setEntity((HttpEntity)entity);
                responseData = this.restClient.performRequest(scriptRequest);
                result = EntityUtils.toString((HttpEntity)responseData.getEntity());
                jsonObject = JSON.parseObject((String)result);
                hitsobject = (JSONObject)jsonObject.get((Object)"hits");
                array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            }
            LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
            header.put("scustId", "\u6838\u5fc3\u5ba2\u6237\u53f7");
            header.put("custId", "\u5ba2\u6237\u53f7");
            header.put("name", "\u59d3\u540d");
            header.put("idType", "\u8bc1\u4ef6\u7c7b\u578b");
            header.put("idCard", "\u8bc1\u4ef6\u53f7\u7801");
            header.put("sex", "\u6027\u522b");
            header.put("age", "\u5e74\u9f84");
            header.put("birthDay", "\u51fa\u751f\u65e5\u671f");
            header.put("custClass", "\u5ba2\u6237\u7b49\u7ea7");
            header.put("custType", "\u5ba2\u6237\u7c7b\u578b");
            header.put("province", "\u7701\u4efd");
            header.put("education", "\u5b66\u5386");
            header.put("vaild", "\u662f\u5426\u6709\u6548\u5ba2\u6237");
            header.put("pIncome", "\u5e74\u6536\u5165(\u4e07)");
            header.put("num", "\u4fdd\u5355\u4ef6\u6570");
            CsvUtil.export((HttpServletRequest)request, (HttpServletResponse)response, (String)"customer", header, customers);
            logger.info("\u5bfc\u51fa\u51fa\u65f6\u95f4\uff1a" + DateUtils.getTime());
        }
        catch (Exception e) {
            logger.info("\u5bfc\u51fa\u51fa\u9519\uff1a" + DateUtils.getTime());
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/exportSameZero"})
    public void exportSameZero(HttpServletResponse response, HttpServletRequest request) {
        logger.info("\u5bfc\u51fa\u56db\u8981\u7d20\u8fdb\u65f6\u95f4\uff1a" + DateUtils.getTime());
        try {
            Request scriptRequest = new Request("GET", "/shanglifeecif.samecustomer/_search?sort=name:asc&q=sametype:0&size=10000&scroll=5m");
            Response responseData = this.restClient.performRequest(scriptRequest);
            String result = EntityUtils.toString((HttpEntity)responseData.getEntity());
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONObject hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            JSONArray array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList<Customer> customers = new ArrayList<Customer>();
            String scroll_id = jsonObject.getString("_scroll_id");
            NStringEntity entity = new NStringEntity("{\n  \"scroll_id\": \"" + scroll_id + "\",\n  \"scroll\": \"5m\"\n}", ContentType.APPLICATION_JSON);
            while (array.size() != 0) {
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject json = (JSONObject)array.get(i);
                    HashMap<String, String> mp = new HashMap<String, String>();
                    Customer customer = new Customer();
                    json.getString("_source");
                    mp.put("id", json.getString("_id"));
                    JSONObject jsonOb = JSON.parseObject((String)json.getString("_source"));
                    mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                    customer.setScustId("\t" + jsonOb.getString("scustid"));
                    customer.setName(jsonOb.getString("name"));
                    customer.setSex("0".equals(jsonOb.getString("gender")) ? "\u7537" : "\u5973");
                    if (mp.containsKey("birthday")) {
                        String birthday = jsonOb.getString("birthday");
                        mp.put("birthday", birthday);
                        customer.setBirthDay("\t" + birthday);
                        customer.setAge(DateUtils.getAge((Date)DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)jsonOb.getString("birthday"))));
                    }
                    if (mp.containsKey("idcard")) {
                        customer.setIdType("\u8eab\u4efd\u8bc1");
                        String idcard = jsonOb.getString("idcard");
                        if (idcard.length() > 6) {
                            customer.setIdCard("\t" + idcard.replaceAll(idcard.substring(idcard.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("passport")) {
                        customer.setIdType("\u62a4\u7167");
                        String passport = jsonOb.getString("passport");
                        if (passport.length() > 6) {
                            customer.setIdCard("\t" + passport.replaceAll(passport.substring(passport.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("dlicense")) {
                        customer.setIdType("\u9a7e\u9a76\u8bc1");
                        String dlicense = jsonOb.getString("dlicense");
                        if (dlicense.length() > 6) {
                            customer.setIdCard("\t" + dlicense.replaceAll(dlicense.substring(dlicense.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("otheridnumber")) {
                        customer.setIdType("\u5176\u5b83\u8bc1\u4ef6\u7c7b\u578b");
                        String otheridnumber = jsonOb.getString("otheridnumber");
                        if (otheridnumber.length() > 6) {
                            customer.setIdCard("\t" + otheridnumber.replaceAll(otheridnumber.substring(otheridnumber.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    }
                    customers.add(customer);
                }
                scriptRequest = new Request("GET", "/_search/scroll");
                scriptRequest.setEntity((HttpEntity)entity);
                responseData = this.restClient.performRequest(scriptRequest);
                result = EntityUtils.toString((HttpEntity)responseData.getEntity());
                jsonObject = JSON.parseObject((String)result);
                hitsobject = (JSONObject)jsonObject.get((Object)"hits");
                array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            }
            LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
            header.put("scustId", "\u6838\u5fc3\u5ba2\u6237\u53f7");
            header.put("name", "\u59d3\u540d");
            header.put("idType", "\u8bc1\u4ef6\u7c7b\u578b");
            header.put("idCard", "\u8bc1\u4ef6\u53f7\u7801");
            header.put("sex", "\u6027\u522b");
            header.put("birthDay", "\u51fa\u751f\u65e5\u671f");
            CsvUtil.export((HttpServletRequest)request, (HttpServletResponse)response, (String)"customer", header, customers);
            logger.info("\u5bfc\u51fa\u56db\u8981\u7d20\u51fa\u65f6\u95f4\uff1a" + DateUtils.getTime());
        }
        catch (Exception e) {
            logger.info("\u5bfc\u51fa\u56db\u8981\u7d20\u51fa\u9519\uff1a" + DateUtils.getTime());
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/exportSameOne"})
    public void exportSameOne(HttpServletResponse response, HttpServletRequest request) {
        logger.info("\u5bfc\u51fa\u4e09\u8981\u7d20\u8fdb\u65f6\u95f4\uff1a" + DateUtils.getTime());
        try {
            Request scriptRequest = new Request("GET", "/shanglifeecif.samecustomer/_search?sort=name:asc,gender:asc,birthday:asc&q=sametype:1&size=10000&scroll=5m");
            Response responseData = this.restClient.performRequest(scriptRequest);
            String result = EntityUtils.toString((HttpEntity)responseData.getEntity());
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONObject hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            JSONArray array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList<Customer> customers = new ArrayList<Customer>();
            String scroll_id = jsonObject.getString("_scroll_id");
            NStringEntity entity = new NStringEntity("{\n  \"scroll_id\": \"" + scroll_id + "\",\n  \"scroll\": \"5m\"\n}", ContentType.APPLICATION_JSON);
            while (array.size() != 0) {
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject json = (JSONObject)array.get(i);
                    HashMap<String, String> mp = new HashMap<String, String>();
                    Customer customer = new Customer();
                    json.getString("_source");
                    mp.put("id", json.getString("_id"));
                    JSONObject jsonOb = JSON.parseObject((String)json.getString("_source"));
                    mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                    customer.setScustId("\t" + jsonOb.getString("scustid"));
                    customer.setName(jsonOb.getString("name"));
                    customer.setSex("0".equals(jsonOb.getString("gender")) ? "\u7537" : "\u5973");
                    if (mp.containsKey("birthday")) {
                        String birthday = jsonOb.getString("birthday");
                        mp.put("birthday", birthday);
                        customer.setBirthDay(birthday);
                        customer.setAge(DateUtils.getAge((Date)DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)jsonOb.getString("birthday"))));
                    }
                    if (mp.containsKey("idcard")) {
                        customer.setIdType("\u8eab\u4efd\u8bc1");
                        String idcard = jsonOb.getString("idcard");
                        if (idcard.length() > 6) {
                            customer.setIdCard("\t" + idcard.replaceAll(idcard.substring(idcard.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("passport")) {
                        customer.setIdType("\u62a4\u7167");
                        String passport = jsonOb.getString("passport");
                        if (passport.length() > 6) {
                            customer.setIdCard("\t" + passport.replaceAll(passport.substring(passport.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("dlicense")) {
                        customer.setIdType("\u9a7e\u9a76\u8bc1");
                        String dlicense = jsonOb.getString("dlicense");
                        if (dlicense.length() > 6) {
                            customer.setIdCard("\t" + dlicense.replaceAll(dlicense.substring(dlicense.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("otheridnumber")) {
                        customer.setIdType("\u5176\u5b83\u8bc1\u4ef6\u7c7b\u578b");
                        String otheridnumber = jsonOb.getString("otheridnumber");
                        if (otheridnumber.length() > 6) {
                            customer.setIdCard("\t" + otheridnumber.replaceAll(otheridnumber.substring(otheridnumber.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    }
                    customers.add(customer);
                }
                scriptRequest = new Request("GET", "/_search/scroll");
                scriptRequest.setEntity((HttpEntity)entity);
                responseData = this.restClient.performRequest(scriptRequest);
                result = EntityUtils.toString((HttpEntity)responseData.getEntity());
                jsonObject = JSON.parseObject((String)result);
                hitsobject = (JSONObject)jsonObject.get((Object)"hits");
                array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            }
            LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
            header.put("scustId", "\u6838\u5fc3\u5ba2\u6237\u53f7");
            header.put("name", "\u59d3\u540d");
            header.put("idType", "\u8bc1\u4ef6\u7c7b\u578b");
            header.put("idCard", "\u8bc1\u4ef6\u53f7\u7801");
            header.put("sex", "\u6027\u522b");
            header.put("birthDay", "\u51fa\u751f\u65e5\u671f");
            CsvUtil.export((HttpServletRequest)request, (HttpServletResponse)response, (String)"customer", header, customers);
            logger.info("\u5bfc\u51fa\u4e09\u8981\u7d20\u51fa\u65f6\u95f4\uff1a" + DateUtils.getTime());
        }
        catch (Exception e) {
            logger.info("\u5bfc\u51fa\u4e09\u8981\u7d20\u51fa\u9519\uff1a" + DateUtils.getTime());
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/exportSameTwo"})
    public void exportSameTwo(HttpServletResponse response, HttpServletRequest request) {
        logger.info("\u5bfc\u51fa\u4e24\u8981\u7d20\u8fdb\u65f6\u95f4\uff1a" + DateUtils.getTime());
        try {
            Request scriptRequest = new Request("GET", "/shanglifeecif.samecustomer/_search?sort=name:asc&q=sametype:2&size=10000&scroll=5m");
            Response responseData = this.restClient.performRequest(scriptRequest);
            String result = EntityUtils.toString((HttpEntity)responseData.getEntity());
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONObject hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            JSONArray array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList<Customer> customers = new ArrayList<Customer>();
            String scroll_id = jsonObject.getString("_scroll_id");
            NStringEntity entity = new NStringEntity("{\n  \"scroll_id\": \"" + scroll_id + "\",\n  \"scroll\": \"5m\"\n}", ContentType.APPLICATION_JSON);
            while (array.size() != 0) {
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject json = (JSONObject)array.get(i);
                    HashMap<String, String> mp = new HashMap<String, String>();
                    Customer customer = new Customer();
                    json.getString("_source");
                    mp.put("id", json.getString("_id"));
                    JSONObject jsonOb = JSON.parseObject((String)json.getString("_source"));
                    mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                    customer.setScustId("\t" + jsonOb.getString("scustid"));
                    customer.setName(jsonOb.getString("name"));
                    customer.setSex("0".equals(jsonOb.getString("gender")) ? "\u7537" : "\u5973");
                    if (mp.containsKey("birthday")) {
                        String birthday = jsonOb.getString("birthday");
                        mp.put("birthday", birthday);
                        customer.setBirthDay("\t" + birthday);
                        customer.setAge(DateUtils.getAge((Date)DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)jsonOb.getString("birthday"))));
                    }
                    if (mp.containsKey("idcard")) {
                        customer.setIdType("\u8eab\u4efd\u8bc1");
                        String idcard = jsonOb.getString("idcard");
                        if (idcard.length() > 6) {
                            customer.setIdCard("\t" + idcard.replaceAll(idcard.substring(idcard.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("passport")) {
                        customer.setIdType("\u62a4\u7167");
                        String passport = jsonOb.getString("passport");
                        if (passport.length() > 6) {
                            customer.setIdCard("\t" + passport.replaceAll(passport.substring(passport.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("dlicense")) {
                        customer.setIdType("\u9a7e\u9a76\u8bc1");
                        String dlicense = jsonOb.getString("dlicense");
                        if (dlicense.length() > 6) {
                            customer.setIdCard("\t" + dlicense.replaceAll(dlicense.substring(dlicense.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("otheridnumber")) {
                        customer.setIdType("\u5176\u5b83\u8bc1\u4ef6\u7c7b\u578b");
                        String otheridnumber = jsonOb.getString("otheridnumber");
                        if (otheridnumber.length() > 6) {
                            customer.setIdCard("\t" + otheridnumber.replaceAll(otheridnumber.substring(otheridnumber.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    }
                    customers.add(customer);
                }
                scriptRequest = new Request("GET", "/_search/scroll");
                scriptRequest.setEntity((HttpEntity)entity);
                responseData = this.restClient.performRequest(scriptRequest);
                result = EntityUtils.toString((HttpEntity)responseData.getEntity());
                jsonObject = JSON.parseObject((String)result);
                hitsobject = (JSONObject)jsonObject.get((Object)"hits");
                array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            }
            LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
            header.put("scustId", "\u6838\u5fc3\u5ba2\u6237\u53f7");
            header.put("name", "\u59d3\u540d");
            header.put("idType", "\u8bc1\u4ef6\u7c7b\u578b");
            header.put("idCard", "\u8bc1\u4ef6\u53f7\u7801");
            header.put("sex", "\u6027\u522b");
            header.put("birthDay", "\u51fa\u751f\u65e5\u671f");
            CsvUtil.export((HttpServletRequest)request, (HttpServletResponse)response, (String)"customer", header, customers);
            logger.info("\u5bfc\u51fa\u4e24\u8981\u7d20\u51fa\u65f6\u95f4\uff1a" + DateUtils.getTime());
        }
        catch (Exception e) {
            logger.info("\u5bfc\u51fa\u4e24\u8981\u7d20\u51fa\u9519\uff1a" + DateUtils.getTime());
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/dataCleaning"})
    public void dataCleaning(HttpServletResponse response, HttpServletRequest request, String sameType) {
        logger.info("\u5bfc\u51fa\u6570\u636e\u6e05\u6d17\u8fdb\u65f6\u95f4\uff1a" + DateUtils.getTime());
        try {
            Request scriptRequest = new Request("GET", "/shanglifeecif.samecustomer/_search?sort=name:asc&q=sametype:" + sameType + "&size=10000&scroll=5m");
            Response responseData = this.restClient.performRequest(scriptRequest);
            String result = EntityUtils.toString((HttpEntity)responseData.getEntity());
            JSONObject jsonObject = JSON.parseObject((String)result);
            JSONObject hitsobject = (JSONObject)jsonObject.get((Object)"hits");
            JSONArray array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            ArrayList<Customer> customers = new ArrayList<Customer>();
            String scroll_id = jsonObject.getString("_scroll_id");
            NStringEntity entity = new NStringEntity("{\n  \"scroll_id\": \"" + scroll_id + "\",\n  \"scroll\": \"5m\"\n}", ContentType.APPLICATION_JSON);
            while (array.size() != 0) {
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject json = (JSONObject)array.get(i);
                    HashMap<String, String> mp = new HashMap<String, String>();
                    Customer customer = new Customer();
                    json.getString("_source");
                    mp.put("id", json.getString("_id"));
                    JSONObject jsonOb = JSON.parseObject((String)json.getString("_source"));
                    mp.putAll((Map)JSON.parseObject((String)json.getString("_source"), Map.class));
                    customer.setScustId("\t" + jsonOb.getString("scustid"));
                    customer.setName(jsonOb.getString("name"));
                    customer.setSex("0".equals(jsonOb.getString("gender")) ? "\u7537" : "\u5973");
                    if (mp.containsKey("birthday")) {
                        String birthday = jsonOb.getString("birthday");
                        mp.put("birthday", birthday);
                        customer.setBirthDay("\t" + birthday);
                        customer.setAge(DateUtils.getAge((Date)DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)jsonOb.getString("birthday"))));
                    }
                    if (mp.containsKey("idcard")) {
                        customer.setIdType("\u8eab\u4efd\u8bc1");
                        String idcard = jsonOb.getString("idcard");
                        if (idcard.length() > 6) {
                            customer.setIdCard("\t" + idcard.replaceAll(idcard.substring(idcard.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("passport")) {
                        customer.setIdType("\u62a4\u7167");
                        String passport = jsonOb.getString("passport");
                        if (passport.length() > 6) {
                            customer.setIdCard("\t" + passport.replaceAll(passport.substring(passport.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("dlicense")) {
                        customer.setIdType("\u9a7e\u9a76\u8bc1");
                        String dlicense = jsonOb.getString("dlicense");
                        if (dlicense.length() > 6) {
                            customer.setIdCard("\t" + dlicense.replaceAll(dlicense.substring(dlicense.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    } else if (mp.containsKey("otheridnumber")) {
                        customer.setIdType("\u5176\u5b83\u8bc1\u4ef6\u7c7b\u578b");
                        String otheridnumber = jsonOb.getString("otheridnumber");
                        if (otheridnumber.length() > 6) {
                            customer.setIdCard("\t" + otheridnumber.replaceAll(otheridnumber.substring(otheridnumber.length() - 6), "******"));
                        } else {
                            customer.setIdCard("\t******");
                        }
                    }
                    customer.setZipCode("\t" + jsonOb.getString("zipcode"));
                    customer.setMobile("\t" + jsonOb.getString("mobile"));
                    customer.setEmail("\t" + jsonOb.getString("email"));
                    customer.setPinDate(jsonOb.getString("pindate"));
                    customer.setAgentName(jsonOb.getString("agentname"));
                    customer.setSalecomName(jsonOb.getString("salecomname"));
                    customers.add(customer);
                }
                scriptRequest = new Request("GET", "/_search/scroll");
                scriptRequest.setEntity((HttpEntity)entity);
                responseData = this.restClient.performRequest(scriptRequest);
                result = EntityUtils.toString((HttpEntity)responseData.getEntity());
                jsonObject = JSON.parseObject((String)result);
                hitsobject = (JSONObject)jsonObject.get((Object)"hits");
                array = JSON.parseArray((String)hitsobject.get((Object)"hits").toString());
            }
            LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
            header.put("scustId", "\u6838\u5fc3\u5ba2\u6237\u53f7");
            header.put("name", "\u59d3\u540d");
            header.put("idType", "\u8bc1\u4ef6\u7c7b\u578b");
            header.put("idCard", "\u8bc1\u4ef6\u53f7\u7801");
            header.put("sex", "\u6027\u522b");
            header.put("birthDay", "\u51fa\u751f\u65e5\u671f");
            if ("8".equals(sameType) || "16".equals(sameType)) {
                header.put("mobile", "\u624b\u673a\u53f7\u7801");
            } else if ("9".equals(sameType)) {
                header.put("zipCode", "\u90ae\u653f\u7f16\u7801");
            } else if ("12".equals(sameType)) {
                header.put("degree", "\u5b66\u5386");
            } else if ("14".equals(sameType)) {
                header.put("email", "\u90ae\u7bb1");
            } else if ("15".equals(sameType)) {
                header.put("pinDate", "\u8d77\u4fdd\u65e5\u671f");
            } else if ("18".equals(sameType)) {
                header.put("agentName", "\u4e1a\u52a1\u5458\u540d\u79f0");
            } else if ("19".equals(sameType)) {
                header.put("salecomName", "\u4e1a\u7ee9\u5f52\u5c5e");
            }
            CsvUtil.export((HttpServletRequest)request, (HttpServletResponse)response, (String)"customer", header, customers);
            logger.info("\u5bfc\u51fa\u6570\u636e\u6e05\u6d17\u51fa\u65f6\u95f4\uff1a" + DateUtils.getTime());
        }
        catch (Exception e) {
            logger.info("\u5bfc\u51fa\u6570\u636e\u6e05\u6d17\u51fa\u9519\uff1a" + DateUtils.getTime());
            e.printStackTrace();
        }
    }

    public Map getLables(JSONObject jsonObject, String deptCode) throws Exception {
        HashMap<String, Object> mpInfo = new HashMap<String, Object>();
        JSONObject source = JSON.parseObject((String)jsonObject.getString("_source"));
        String indid = jsonObject.getString("_id");
        mpInfo.put("id", indid);
        String salecom = source.getString("salecom");
        if (StringUtils.isEmpty((String)deptCode) || deptCode.equals(salecom)) {
            mpInfo.putAll((Map)JSON.parseObject((String)jsonObject.getString("_source"), Map.class));
        } else {
            logger.info(jsonObject.toJSONString());
            Map maps = (Map)JSON.parseObject((String)jsonObject.getString("_source"), Map.class);
            ArrayList<String> publicLabels = new ArrayList<String>();
            publicLabels.add("label1");
            publicLabels.add("label2");
            publicLabels.add("label3");
            publicLabels.add("label4");
            publicLabels.add("label9");
            publicLabels.add("label10");
            publicLabels.add("label21");
            publicLabels.add("Label67");
            publicLabels.add("Label69");
            publicLabels.add("Label70");
            publicLabels.add("Label71");
            publicLabels.add("Label74");
            publicLabels.add("label77");
            publicLabels.add("Label80");
            publicLabels.add("Label96");
            publicLabels.add("Label97");
            publicLabels.add("Label100");
            publicLabels.add("Label101");
            publicLabels.add("Label103");
            publicLabels.add("Label104");
            publicLabels.add("Label105");
            publicLabels.add("Label106");
            for (Map.Entry entry : maps.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("label")) {
                    if (!publicLabels.contains(key)) continue;
                    mpInfo.put(key, entry.getValue());
                    continue;
                }
                mpInfo.put(key, entry.getValue());
            }
        }
        if (mpInfo.containsKey("birthday")) {
            mpInfo.put("birthday", source.getString("birthday"));
            mpInfo.put("age", DateUtils.getAge((Date)DateUtils.dateTime((String)DateUtils.YYYY_MM_DD, (String)source.getString("birthday"))));
        } else {
            mpInfo.put("birthday", "");
            mpInfo.put("age", "");
        }
        return mpInfo;
    }
}

