/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.data.config;

import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticSearchConfig {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchConfig.class);
    @Value(value="${elasticsearch.hostlist}")
    private String hostlist;
    @Value(value="${elasticsearch.port}")
    private int esPort;
    @Value(value="${elasticsearch.cluster.name}")
    private String esName;
    private static final int TIME_OUT = 600000;

    @Bean
    public RestClient esClient() {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.httpHost());
        Header[] defaultHeaders = new Header[]{new BasicHeader("header", "value")};
        builder.setDefaultHeaders(defaultHeaders);
        builder.setFailureListener((RestClient.FailureListener)new /* Unavailable Anonymous Inner Class!! */);
        builder.setRequestConfigCallback((RestClientBuilder.RequestConfigCallback)new /* Unavailable Anonymous Inner Class!! */);
        return builder.build();
    }

    public HttpHost[] httpHost() {
        String[] split = this.hostlist.split(",");
        HttpHost[] httpHostArray = new HttpHost[split.length];
        for (int i = 0; i < split.length; ++i) {
            String item = split[i];
            httpHostArray[i] = new HttpHost(item.split(":")[0], Integer.parseInt(item.split(":")[1]), "http");
        }
        return httpHostArray;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

