/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.auth.controller;

import com.alibaba.fastjson.parser.ParserConfig;
import com.dgtis.auth.form.LoginBody;
import com.dgtis.auth.service.SysLoginService;
import com.dgtis.common.core.domain.R;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.security.service.TokenService;
import com.dgtis.system.api.model.LoginUser;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TokenController {
    @Autowired
    private TokenService tokenService;
    @Autowired
    private SysLoginService sysLoginService;

    @PostMapping(value={"login"})
    public R<?> login(@RequestBody LoginBody form) {
        LoginUser userInfo = this.sysLoginService.login(form.getUsername(), form.getPassword());
        return R.ok((Object)this.tokenService.createToken(userInfo));
    }

    @DeleteMapping(value={"logout"})
    public R<?> logout(HttpServletRequest request) {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        if (StringUtils.isNotNull((Object)loginUser)) {
            String username = loginUser.getUsername();
            this.tokenService.delLoginUser(loginUser.getToken());
            this.sysLoginService.logout(username);
        }
        return R.ok();
    }

    @PostMapping(value={"refresh"})
    public R<?> refresh(HttpServletRequest request) {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        if (StringUtils.isNotNull((Object)loginUser)) {
            this.tokenService.refreshToken(loginUser);
            return R.ok();
        }
        return R.ok();
    }

    @PostMapping(value={"parserConfig"})
    public R<?> parserConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        ParserConfig fastJsonConf = ParserConfig.getGlobalInstance();
        map.put("autoType", String.valueOf(fastJsonConf.isAutoTypeSupport()));
        map.put("safeMode", String.valueOf(fastJsonConf.isSafeMode()));
        map.put("other", fastJsonConf.getDefaultClassLoader().getResource(".").toString());
        return R.ok(map);
    }
}

