/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.auth.service;

import com.dgtis.common.core.domain.R;
import com.dgtis.common.core.enums.UserStatus;
import com.dgtis.common.core.exception.BaseException;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.security.utils.SecurityUtils;
import com.dgtis.system.api.RemoteLogService;
import com.dgtis.system.api.RemoteUserService;
import com.dgtis.system.api.domain.SysUser;
import com.dgtis.system.api.model.LoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysLoginService {
    @Autowired
    private RemoteLogService remoteLogService;
    @Autowired
    private RemoteUserService remoteUserService;

    public LoginUser login(String username, String password) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{username, password})) {
            this.remoteLogService.saveLogininfor(username, "Error", "\u7528\u6237/\u5bc6\u7801\u5fc5\u987b\u586b\u5199");
            throw new BaseException("\u7528\u6237/\u5bc6\u7801\u5fc5\u987b\u586b\u5199");
        }
        if (password.length() < 5 || password.length() > 20) {
            this.remoteLogService.saveLogininfor(username, "Error", "\u7528\u6237\u5bc6\u7801\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
            throw new BaseException("\u7528\u6237\u5bc6\u7801\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
        }
        if (username.length() < 2 || username.length() > 20) {
            this.remoteLogService.saveLogininfor(username, "Error", "\u7528\u6237\u540d\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
            throw new BaseException("\u7528\u6237\u540d\u4e0d\u5728\u6307\u5b9a\u8303\u56f4");
        }
        R userResult = this.remoteUserService.getUserInfo(username);
        if (R.FAIL == userResult.getCode()) {
            throw new BaseException(userResult.getMsg());
        }
        if (StringUtils.isNull((Object)userResult) || StringUtils.isNull((Object)userResult.getData())) {
            this.remoteLogService.saveLogininfor(username, "Error", "\u767b\u5f55\u7528\u6237\u4e0d\u5b58\u5728");
            throw new BaseException("\u767b\u5f55\u7528\u6237\uff1a" + username + " \u4e0d\u5b58\u5728");
        }
        LoginUser userInfo = (LoginUser)userResult.getData();
        SysUser user = ((LoginUser)userResult.getData()).getSysUser();
        if (UserStatus.DELETED.getCode().equals(user.getDelFlag())) {
            this.remoteLogService.saveLogininfor(username, "Error", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u5220\u9664");
            throw new BaseException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u88ab\u5220\u9664");
        }
        if (UserStatus.DISABLE.getCode().equals(user.getStatus())) {
            this.remoteLogService.saveLogininfor(username, "Error", "\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            throw new BaseException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + username + " \u5df2\u505c\u7528");
        }
        if (!SecurityUtils.matchesPassword((String)password, (String)user.getPassword())) {
            this.remoteLogService.saveLogininfor(username, "Error", "\u7528\u6237\u5bc6\u7801\u9519\u8bef");
            throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728/\u5bc6\u7801\u9519\u8bef");
        }
        this.remoteLogService.saveLogininfor(username, "Success", "\u767b\u5f55\u6210\u529f");
        return userInfo;
    }

    public void logout(String loginName) {
        this.remoteLogService.saveLogininfor(loginName, "Logout", "\u9000\u51fa\u6210\u529f");
    }
}

