/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.controller;

import com.dgtis.common.core.utils.poi.ExcelUtil;
import com.dgtis.common.core.web.controller.BaseController;
import com.dgtis.common.core.web.domain.AjaxResult;
import com.dgtis.common.core.web.page.TableDataInfo;
import com.dgtis.common.log.annotation.Log;
import com.dgtis.common.log.enums.BusinessType;
import com.dgtis.common.security.annotation.PreAuthorize;
import com.dgtis.common.security.utils.SecurityUtils;
import com.dgtis.system.domain.SysConfig;
import com.dgtis.system.service.ISysConfigService;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config"})
public class SysConfigController
extends BaseController {
    @Autowired
    private ISysConfigService configService;

    @PreAuthorize(hasPermi="system:config:list")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysConfig config) {
        this.startPage();
        List list = this.configService.selectConfigList(config);
        return this.getDataTable(list);
    }

    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(hasPermi="system:config:export")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysConfig config) throws IOException {
        List list = this.configService.selectConfigList(config);
        ExcelUtil util = new ExcelUtil(SysConfig.class);
        util.exportExcel(response, list, "\u53c2\u6570\u6570\u636e");
    }

    @GetMapping(value={"/{configId}"})
    public AjaxResult getInfo(@PathVariable Long configId) {
        return AjaxResult.success((Object)this.configService.selectConfigById(configId));
    }

    @GetMapping(value={"/configKey/{configKey}"})
    public AjaxResult getConfigKey(@PathVariable String configKey) {
        return AjaxResult.success((String)this.configService.selectConfigByKey(configKey));
    }

    @PreAuthorize(hasPermi="system:config:add")
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysConfig config) {
        if ("1".equals(this.configService.checkConfigKeyUnique(config))) {
            return AjaxResult.error((String)("\u65b0\u589e\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728"));
        }
        config.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.configService.insertConfig(config));
    }

    @PreAuthorize(hasPermi="system:config:edit")
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysConfig config) {
        if ("1".equals(this.configService.checkConfigKeyUnique(config))) {
            return AjaxResult.error((String)("\u4fee\u6539\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728"));
        }
        config.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.configService.updateConfig(config));
    }

    @PreAuthorize(hasPermi="system:config:remove")
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{configIds}"})
    public AjaxResult remove(@PathVariable Long[] configIds) {
        return this.toAjax(this.configService.deleteConfigByIds(configIds));
    }

    @PreAuthorize(hasPermi="system:config:remove")
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.CLEAN)
    @DeleteMapping(value={"/clearCache"})
    public AjaxResult clearCache() {
        this.configService.clearCache();
        return AjaxResult.success();
    }
}

