/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.data.api;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.dgtis.common.core.utils.DateUtils;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.core.web.controller.BaseController;
import com.dgtis.common.core.web.domain.AjaxResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/index"})
public class IndexApiController
extends BaseController {
    @Autowired
    private RestClient restClient;

    @GetMapping(value={"/riskcode"})
    @ResponseBody
    public AjaxResult riskcode() {
        ArrayList<String> xaxisData = new ArrayList<String>();
        ArrayList seriesData = new ArrayList();
        try {
            this.logger.info("\u8fdb\u9669\u79cd\u7c7b\u522b\u65f6\u95f4\uff1a" + DateUtils.getTime());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("pretty", "true");
            Request scriptRequest = new Request("GET", "/shanglifeecif.riskcode_statistics/_search?pretty=true");
            Response response = this.restClient.performRequest(scriptRequest);
            this.logger.info("\u9669\u79cd\u7c7b\u522b\u8bf7\u6c42\u54cd\u5e94\u65f6\u95f4\uff1a" + DateUtils.getTime());
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotEmpty((String)jsonStr)) {
                JSONArray hits;
                JSONObject jsonObject = JSONUtil.parseObj((String)jsonStr);
                if ((jsonObject = jsonObject.getJSONObject((Object)"hits")) != null && (hits = jsonObject.getJSONArray((Object)"hits")) != null && hits.size() > 0) {
                    ArrayList<String> khnum = new ArrayList<String>();
                    ArrayList<String> bdtotalPrem = new ArrayList<String>();
                    for (Object o : hits) {
                        JSONObject object = JSONUtil.parseObj(o);
                        if (object == null) continue;
                        JSONObject source = object.getJSONObject((Object)"_source");
                        xaxisData.add(source.getStr((Object)"kindname"));
                        String num = source.getStr((Object)"khnum");
                        khnum.add(num);
                        String tatolprem = source.getStr((Object)"tatolprem");
                        if ("0".equals(num)) {
                            bdtotalPrem.add("0");
                            continue;
                        }
                        bdtotalPrem.add(String.format("%.2f", Float.valueOf(Float.parseFloat(tatolprem) / Float.parseFloat(num))));
                    }
                    HashMap<String, Object> code1 = new HashMap<String, Object>();
                    code1.put("name", "\u5b58\u91cf\u5ba2\u6237\u6570\u91cf");
                    code1.put("data", khnum);
                    seriesData.add(code1);
                    HashMap<String, Object> code2 = new HashMap<String, Object>();
                    code2.put("name", "\u88ab\u4fdd\u4eba\u4eba\u5747\u4fdd\u989d");
                    code2.put("data", bdtotalPrem);
                    seriesData.add(code2);
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u9669\u79cd\u7c7b\u522b\u62a5\u9519\u65f6\u95f4\uff1a" + DateUtils.getTime());
            e.printStackTrace();
            return AjaxResult.error((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        HashMap<String, ArrayList<Object>> data = new HashMap<String, ArrayList<Object>>();
        data.put("xaxisData", xaxisData);
        data.put("seriesData", seriesData);
        this.logger.info("\u51fa\u9669\u79cd\u7c7b\u522b\u65f6\u95f4\uff1a" + DateUtils.getTime());
        return AjaxResult.success((String)"\u9669\u79cd\u6570\u636e\u8fd4\u56de\u6210\u529f!", data);
    }

    @GetMapping(value={"/bdNumDis"})
    @ResponseBody
    public AjaxResult bdNumDis() {
        Map<K, V>[] seriesData = new HashMap[]{};
        try {
            this.logger.info("\u8fdb\u4fdd\u5355\u4ef6\u6570\u65f6\u95f4\uff1a" + DateUtils.getTime());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("pretty", "true");
            Request scriptRequest = new Request("GET", "/shanglifeecif.bdnum_distribution/_search?pretty=true");
            Response response = this.restClient.performRequest(scriptRequest);
            this.logger.info("\u4fdd\u5355\u4ef6\u6570\u8bf7\u6c42\u54cd\u5e94\u65f6\u95f4\uff1a" + DateUtils.getTime());
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotEmpty((String)jsonStr)) {
                JSONArray hits;
                JSONObject jsonObject = JSONUtil.parseObj((String)jsonStr);
                if ((jsonObject = jsonObject.getJSONObject((Object)"hits")) != null && (hits = jsonObject.getJSONArray((Object)"hits")) != null && hits.size() > 0) {
                    seriesData = new HashMap[hits.size()];
                    for (Object e : hits) {
                        try {
                            JSONObject object = JSONUtil.parseObj(e);
                            if (object == null) continue;
                            JSONObject source = object.getJSONObject((Object)"_source");
                            String string = object.getStr((Object)"_id");
                            String labelname = source.getStr((Object)"labelname").trim();
                            String bdnum = source.getStr((Object)"bdnum").trim();
                            HashMap<String, String> m = new HashMap<String, String>();
                            m.put("name", labelname);
                            m.put("value", bdnum);
                            seriesData[Integer.valueOf((String)string).intValue() - 1] = m;
                        }
                        catch (NullPointerException | NumberFormatException e2) {
                            this.logger.warn("\u4fdd\u5355\u4ef6\u6570\u8ba1\u7b97\u5f02\u5e38\uff0c\u8be5\u6761\u8bb0\u5f55\u4e0d\u8fd4\u56de\uff0c\u8bb0\u5f55\u4fe1\u606f: " + e, (Throwable)e2);
                        }
                    }
                    ArrayList<HashMap> list = new ArrayList<HashMap>(seriesData.length);
                    for (HashMap hashMap : seriesData) {
                        if (hashMap == null) continue;
                        list.add(hashMap);
                    }
                    HashMap[] hashMapArray = new HashMap[]{};
                    seriesData = list.toArray(hashMapArray);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5355\u4ef6\u6570\u51fa\u9519\u65f6\u95f4\uff1a" + DateUtils.getTime());
            e.printStackTrace();
            return AjaxResult.error((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        HashMap<String, HashMap[]> data = new HashMap<String, HashMap[]>();
        data.put("seriesData", (HashMap[])seriesData);
        this.logger.info("\u51fa\u4fdd\u5355\u4ef6\u6570\u65f6\u95f4\uff1a" + DateUtils.getTime());
        return AjaxResult.success((String)"\u4fdd\u5355\u4ef6\u6570\u5206\u5e03\u6570\u636e\u8fd4\u56de\u6210\u529f!", data);
    }

    @GetMapping(value={"/ageSexDis"})
    @ResponseBody
    public AjaxResult ageSexDis() {
        ArrayList<String> legendData = new ArrayList<String>();
        legendData.add("\u7537");
        legendData.add("\u5973");
        ArrayList<String> xaxisData = new ArrayList<String>();
        xaxisData.add("\u513f\u7ae5");
        xaxisData.add("\u5c11\u5e74");
        xaxisData.add("\u9752\u5e74");
        xaxisData.add("\u4e2d\u5e74");
        xaxisData.add("\u8001\u5e74");
        ArrayList<String[]> seriesData = new ArrayList<String[]>();
        try {
            this.logger.info("\u8fdb\u5ba2\u6237\u5e74\u9f84\u6bb5\u65f6\u95f4\uff1a" + DateUtils.getTime());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("pretty", "true");
            Request scriptRequest = new Request("GET", "/shanglifeecif.age_sex_distribution/_search?pretty=true");
            Response response = this.restClient.performRequest(scriptRequest);
            this.logger.info("\u5ba2\u6237\u5e74\u9f84\u6bb5\u8bf7\u6c42\u54cd\u5e94\u65f6\u95f4\uff1a" + DateUtils.getTime());
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotEmpty((String)jsonStr)) {
                JSONArray hits;
                JSONObject jsonObject = JSONUtil.parseObj((String)jsonStr);
                if ((jsonObject = jsonObject.getJSONObject((Object)"hits")) != null && (hits = jsonObject.getJSONArray((Object)"hits")) != null && hits.size() > 0) {
                    String[] manNum = new String[5];
                    String[] womanNum = new String[5];
                    for (Object o : hits) {
                        JSONObject object = JSONUtil.parseObj(o);
                        if (object == null) continue;
                        JSONObject source = object.getJSONObject((Object)"_source");
                        String gender = source.getStr((Object)"gender");
                        String labelname = source.getStr((Object)"labelname").trim();
                        String cusnum = source.getStr((Object)"cusnum");
                        if ("0".equals(gender)) {
                            if ("\u513f\u7ae5".equals(labelname)) {
                                manNum[0] = cusnum;
                                continue;
                            }
                            if ("\u5c11\u5e74".equals(labelname)) {
                                manNum[1] = cusnum;
                                continue;
                            }
                            if ("\u9752\u5e74".equals(labelname)) {
                                manNum[2] = cusnum;
                                continue;
                            }
                            if ("\u4e2d\u5e74".equals(labelname)) {
                                manNum[3] = cusnum;
                                continue;
                            }
                            manNum[4] = cusnum;
                            continue;
                        }
                        if ("\u513f\u7ae5".equals(labelname)) {
                            womanNum[0] = cusnum;
                            continue;
                        }
                        if ("\u5c11\u5e74".equals(labelname)) {
                            womanNum[1] = cusnum;
                            continue;
                        }
                        if ("\u9752\u5e74".equals(labelname)) {
                            womanNum[2] = cusnum;
                            continue;
                        }
                        if ("\u4e2d\u5e74".equals(labelname)) {
                            womanNum[3] = cusnum;
                            continue;
                        }
                        womanNum[4] = cusnum;
                    }
                    seriesData.add(manNum);
                    seriesData.add(womanNum);
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u5ba2\u6237\u5e74\u9f84\u6bb5\u62a5\u9519\u65f6\u95f4\uff1a" + DateUtils.getTime());
            e.printStackTrace();
            return AjaxResult.error((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        HashMap<String, ArrayList<Object>> data = new HashMap<String, ArrayList<Object>>();
        data.put("legendData", legendData);
        data.put("xaxisData", xaxisData);
        data.put("seriesData", seriesData);
        this.logger.info("\u51fa\u5ba2\u6237\u5e74\u9f84\u6bb5\u65f6\u95f4\uff1a" + DateUtils.getTime());
        return AjaxResult.success((String)"\u5ba2\u6237\u5e74\u9f84\u6bb5\u6027\u522b\u5206\u5e03\u6570\u636e\u8fd4\u56de\u6210\u529f!", data);
    }

    @GetMapping(value={"/effectiveCustomer"})
    @ResponseBody
    public AjaxResult effectiveCustomer() {
        ArrayList<String> xaxisData = new ArrayList<String>();
        ArrayList seriesData = new ArrayList();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        ArrayList list3 = new ArrayList();
        ArrayList list4 = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapData = new HashMap<String, String>();
        try {
            this.logger.info("\u8fdb\u6709\u6548\u5ba2\u6237\u65f6\u95f4\uff1a" + DateUtils.getTime());
            Request scriptRequest = new Request("GET", "/shanglifeecif.effectivecustomer/_search?sort=fadatey:asc&size=100&pretty=true");
            Response response = this.restClient.performRequest(scriptRequest);
            this.logger.info("\u6709\u6548\u5ba2\u6237\u8bf7\u6c42\u54cd\u5e94\u65f6\u95f4\uff1a" + DateUtils.getTime());
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotEmpty((String)jsonStr)) {
                JSONArray hits;
                JSONObject jsonObject = JSONUtil.parseObj((String)jsonStr);
                if ((jsonObject = jsonObject.getJSONObject((Object)"hits")) != null && (hits = jsonObject.getJSONArray((Object)"hits")) != null && hits.size() > 0) {
                    for (Object o : hits) {
                        JSONObject object = JSONUtil.parseObj(o);
                        if (object == null) continue;
                        JSONObject source = object.getJSONObject((Object)"_source");
                        String fadatey = source.getStr((Object)"fadatey").trim();
                        String custclass = source.getStr((Object)"custclass").trim();
                        String cnum = source.getStr((Object)"cnum").trim();
                        if (!map.containsKey(fadatey)) {
                            xaxisData.add(fadatey);
                            map.put(fadatey, fadatey);
                        }
                        mapData.put(fadatey + custclass, cnum);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u6709\u6548\u5ba2\u6237\u62a5\u9519\u65f6\u95f4\uff1a" + DateUtils.getTime());
            e.printStackTrace();
            return AjaxResult.error((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        for (int i = 0; i < xaxisData.size(); ++i) {
            list1.add(mapData.get((String)xaxisData.get(i) + "1"));
            list2.add(mapData.get((String)xaxisData.get(i) + "2"));
            list3.add(mapData.get((String)xaxisData.get(i) + "3"));
            list4.add(mapData.get((String)xaxisData.get(i) + "4"));
        }
        map1.put("name", "\u94bb\u77f3");
        map1.put("data", list1);
        map2.put("name", "\u767d\u91d1");
        map2.put("data", list2);
        map3.put("name", "\u9ec4\u91d1");
        map3.put("data", list3);
        map4.put("name", "\u666e\u901a");
        map4.put("data", list4);
        seriesData.add(map1);
        seriesData.add(map2);
        seriesData.add(map3);
        seriesData.add(map4);
        HashMap<String, ArrayList<Object>> data = new HashMap<String, ArrayList<Object>>();
        data.put("xaxisData", xaxisData);
        data.put("seriesData", seriesData);
        this.logger.info("\u51fa\u6709\u6548\u5ba2\u6237\u65f6\u95f4\uff1a" + DateUtils.getTime());
        return AjaxResult.success((String)"\u6709\u6548\u5ba2\u6237\u6570\u636e\u8fd4\u56de\u6210\u529f!", data);
    }
}

