/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.controller;

import com.dgtis.common.core.utils.poi.ExcelUtil;
import com.dgtis.common.core.web.controller.BaseController;
import com.dgtis.common.core.web.domain.AjaxResult;
import com.dgtis.common.core.web.page.TableDataInfo;
import com.dgtis.common.log.annotation.Log;
import com.dgtis.common.log.enums.BusinessType;
import com.dgtis.common.security.annotation.PreAuthorize;
import com.dgtis.system.api.domain.SysOperLog;
import com.dgtis.system.service.ISysOperLogService;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/operlog"})
public class SysOperlogController
extends BaseController {
    @Autowired
    private ISysOperLogService operLogService;

    @PreAuthorize(hasPermi="system:operlog:list")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysOperLog operLog) {
        this.startPage();
        List list = this.operLogService.selectOperLogList(operLog);
        return this.getDataTable(list);
    }

    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @PreAuthorize(hasPermi="system:operlog:export")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysOperLog operLog) throws IOException {
        List list = this.operLogService.selectOperLogList(operLog);
        ExcelUtil util = new ExcelUtil(SysOperLog.class);
        util.exportExcel(response, list, "\u64cd\u4f5c\u65e5\u5fd7");
    }

    @PreAuthorize(hasPermi="system:operlog:remove")
    @DeleteMapping(value={"/{operIds}"})
    public AjaxResult remove(@PathVariable Long[] operIds) {
        return this.toAjax(this.operLogService.deleteOperLogByIds(operIds));
    }

    @PreAuthorize(hasPermi="system:operlog:remove")
    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @DeleteMapping(value={"/clean"})
    public AjaxResult clean() {
        this.operLogService.cleanOperLog();
        return AjaxResult.success();
    }

    @PostMapping
    public AjaxResult add(@RequestBody SysOperLog operLog) {
        return this.toAjax(this.operLogService.insertOperlog(operLog));
    }
}

