/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.OutputFormat;
import org.apache.hive.beeline.Rows;

class SeparatedValuesOutputFormat
implements OutputFormat {
    private final BeeLine beeLine;
    private char separator;

    public SeparatedValuesOutputFormat(BeeLine beeLine, char separator) {
        this.beeLine = beeLine;
        this.setSeparator(separator);
    }

    @Override
    public int print(Rows rows) {
        int count = 0;
        while (rows.hasNext()) {
            if (count == 0 && !this.beeLine.getOpts().getShowHeader()) {
                rows.next();
                ++count;
                continue;
            }
            this.printRow(rows, (Rows.Row)rows.next());
            ++count;
        }
        return count - 1;
    }

    public void printRow(Rows rows, Rows.Row row) {
        String[] vals = row.values;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            buf.append(buf.length() == 0 ? "" : "" + this.getSeparator()).append('\"').append(vals[i] == null ? "" : vals[i].replaceAll("\"", "\"\"")).append('\"');
        }
        this.beeLine.output(buf.toString());
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }
}

