/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.controller;

import com.dgtis.common.core.web.controller.BaseController;
import com.dgtis.common.core.web.domain.AjaxResult;
import com.dgtis.common.core.web.page.TableDataInfo;
import com.dgtis.common.log.annotation.Log;
import com.dgtis.common.log.enums.BusinessType;
import com.dgtis.common.security.annotation.PreAuthorize;
import com.dgtis.common.security.utils.SecurityUtils;
import com.dgtis.system.domain.SysNotice;
import com.dgtis.system.service.ISysNoticeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notice"})
public class SysNoticeController
extends BaseController {
    @Autowired
    private ISysNoticeService noticeService;

    @PreAuthorize(hasPermi="system:notice:list")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysNotice notice) {
        this.startPage();
        List list = this.noticeService.selectNoticeList(notice);
        return this.getDataTable(list);
    }

    @PreAuthorize(hasPermi="system:notice:query")
    @GetMapping(value={"/{noticeId}"})
    public AjaxResult getInfo(@PathVariable Long noticeId) {
        return AjaxResult.success((Object)this.noticeService.selectNoticeById(noticeId));
    }

    @PreAuthorize(hasPermi="system:notice:add")
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.UPDATE)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysNotice notice) {
        notice.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.noticeService.insertNotice(notice));
    }

    @PreAuthorize(hasPermi="system:notice:edit")
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysNotice notice) {
        notice.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.noticeService.updateNotice(notice));
    }

    @PreAuthorize(hasPermi="system:notice:remove")
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{noticeIds}"})
    public AjaxResult remove(@PathVariable Long[] noticeIds) {
        return this.toAjax(this.noticeService.deleteNoticeByIds(noticeIds));
    }
}

