/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.service.impl;

import com.dgtis.common.core.exception.CustomException;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.system.domain.SysPost;
import com.dgtis.system.mapper.SysPostMapper;
import com.dgtis.system.mapper.SysUserPostMapper;
import com.dgtis.system.service.ISysPostService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPostServiceImpl
implements ISysPostService {
    @Autowired
    private SysPostMapper postMapper;
    @Autowired
    private SysUserPostMapper userPostMapper;

    public List<SysPost> selectPostList(SysPost post) {
        return this.postMapper.selectPostList(post);
    }

    public List<SysPost> selectPostAll() {
        return this.postMapper.selectPostAll();
    }

    public SysPost selectPostById(Long postId) {
        return this.postMapper.selectPostById(postId);
    }

    public List<Integer> selectPostListByUserId(Long userId) {
        return this.postMapper.selectPostListByUserId(userId);
    }

    public String checkPostNameUnique(SysPost post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        SysPost info = this.postMapper.checkPostNameUnique(post.getPostName());
        if (StringUtils.isNotNull((Object)info) && info.getPostId().longValue() != postId.longValue()) {
            return "1";
        }
        return "0";
    }

    public String checkPostCodeUnique(SysPost post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        SysPost info = this.postMapper.checkPostCodeUnique(post.getPostCode());
        if (StringUtils.isNotNull((Object)info) && info.getPostId().longValue() != postId.longValue()) {
            return "1";
        }
        return "0";
    }

    public int countUserPostById(Long postId) {
        return this.userPostMapper.countUserPostById(postId);
    }

    public int deletePostById(Long postId) {
        return this.postMapper.deletePostById(postId);
    }

    public int deletePostByIds(Long[] postIds) {
        for (Long postId : postIds) {
            SysPost post = this.selectPostById(postId);
            if (this.countUserPostById(postId) <= 0) continue;
            throw new CustomException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", post.getPostName()));
        }
        return this.postMapper.deletePostByIds(postIds);
    }

    public int insertPost(SysPost post) {
        return this.postMapper.insertPost(post);
    }

    public int updatePost(SysPost post) {
        return this.postMapper.updatePost(post);
    }
}

