/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.util.Arrays;
import java.util.LinkedList;
import jline.console.completer.Completer;
import jline.console.completer.NullCompleter;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.CommandHandler;

public abstract class AbstractCommandHandler
implements CommandHandler {
    private final BeeLine beeLine;
    private final String name;
    private final String[] names;
    private final String helpText;
    private Completer[] parameterCompletors = new Completer[0];

    public AbstractCommandHandler(BeeLine beeLine, String[] names, String helpText, Completer[] completors) {
        this.beeLine = beeLine;
        this.name = names[0];
        this.names = names;
        this.helpText = helpText;
        if (completors == null || completors.length == 0) {
            this.parameterCompletors = new Completer[]{new NullCompleter()};
        } else {
            LinkedList<Completer> c = new LinkedList<Completer>(Arrays.asList(completors));
            c.add((Completer)new NullCompleter());
            this.parameterCompletors = c.toArray(new Completer[0]);
        }
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public String matches(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        String[] parts = this.beeLine.split(line);
        if (parts == null || parts.length == 0) {
            return null;
        }
        for (String name2 : this.names) {
            if (!name2.startsWith(parts[0])) continue;
            return name2;
        }
        return null;
    }

    public void setParameterCompleters(Completer[] parameterCompletors) {
        this.parameterCompletors = parameterCompletors;
    }

    @Override
    public Completer[] getParameterCompleters() {
        return this.parameterCompletors;
    }
}

