/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.gateway.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dgtis.common.core.domain.R;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.redis.service.RedisService;
import com.dgtis.gateway.config.properties.IgnoreWhiteProperties;
import java.util.List;
import javax.annotation.Resource;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class AuthFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    private static final long EXPIRE_TIME = 43200L;
    @Autowired
    private IgnoreWhiteProperties ignoreWhite;
    @Resource(name="stringRedisTemplate")
    private ValueOperations<String, String> sops;
    @Autowired
    private RedisService redisService;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String url = exchange.getRequest().getURI().getPath();
        if (StringUtils.matches((String)url, (List)this.ignoreWhite.getWhites())) {
            return chain.filter(exchange);
        }
        String token = this.getToken(exchange.getRequest());
        if (StringUtils.isBlank((CharSequence)token)) {
            return this.setUnauthorizedResponse(exchange, "\u4ee4\u724c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userStr = (String)this.sops.get((Object)this.getTokenKey(token));
        if (StringUtils.isNull((Object)userStr)) {
            return this.setUnauthorizedResponse(exchange, "\u767b\u5f55\u72b6\u6001\u5df2\u8fc7\u671f");
        }
        JSONObject obj = JSONObject.parseObject((String)userStr);
        String userid = obj.getString("userid");
        String username = obj.getString("username");
        if (StringUtils.isBlank((CharSequence)userid) || StringUtils.isBlank((CharSequence)username)) {
            return this.setUnauthorizedResponse(exchange, "\u4ee4\u724c\u9a8c\u8bc1\u5931\u8d25");
        }
        this.redisService.expire(this.getTokenKey(token), 43200L);
        ServerHttpRequest mutableReq = exchange.getRequest().mutate().header("user_id", new String[]{userid}).header("username", new String[]{username}).build();
        ServerWebExchange mutableExchange = exchange.mutate().request(mutableReq).build();
        return chain.filter(mutableExchange);
    }

    private Mono<Void> setUnauthorizedResponse(ServerWebExchange exchange, String msg) {
        ServerHttpResponse response = exchange.getResponse();
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        response.setStatusCode(HttpStatus.OK);
        log.error("[\u9274\u6743\u5f02\u5e38\u5904\u7406]\u8bf7\u6c42\u8def\u5f84:{}", (Object)exchange.getRequest().getPath());
        return response.writeWith((Publisher)Mono.fromSupplier(() -> {
            DataBufferFactory bufferFactory = response.bufferFactory();
            return bufferFactory.wrap(JSON.toJSONBytes((Object)R.fail((String)msg), (SerializerFeature[])new SerializerFeature[0]));
        }));
    }

    private String getTokenKey(String token) {
        return "login_tokens:" + token;
    }

    private String getToken(ServerHttpRequest request) {
        String token = request.getHeaders().getFirst("Authorization");
        if (StringUtils.isNotEmpty((String)token) && token.startsWith("Bearer ")) {
            token = token.replace("Bearer ", "");
        }
        return token;
    }

    public int getOrder() {
        return -200;
    }
}

