/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.gateway.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.core.web.domain.AjaxResult;
import com.dgtis.gateway.service.ValidateCodeService;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class ValidateCodeFilter
extends AbstractGatewayFilterFactory<Object> {
    private static final String AUTH_URL = "/auth/login";
    @Autowired
    private ValidateCodeService validateCodeService;
    private static final String CODE = "code";
    private static final String UUID = "uuid";

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            if (!StringUtils.containsIgnoreCase((CharSequence)request.getURI().getPath(), (CharSequence)AUTH_URL)) {
                return chain.filter(exchange);
            }
            try {
                String rspStr = this.resolveBodyFromRequest(request);
                JSONObject obj = JSONObject.parseObject((String)rspStr);
                this.validateCodeService.checkCapcha(obj.getString(CODE), obj.getString(UUID));
            }
            catch (Exception e) {
                ServerHttpResponse response = exchange.getResponse();
                response.getHeaders().add("Content-Type", "application/json;charset=UTF-8");
                return exchange.getResponse().writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(JSON.toJSONBytes((Object)AjaxResult.error((String)e.getMessage()), (SerializerFeature[])new SerializerFeature[0]))));
            }
            return chain.filter(exchange);
        };
    }

    private String resolveBodyFromRequest(ServerHttpRequest serverHttpRequest) {
        Flux body = serverHttpRequest.getBody();
        AtomicReference bodyRef = new AtomicReference();
        body.subscribe(buffer -> {
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(buffer.asByteBuffer());
            DataBufferUtils.release((DataBuffer)buffer);
            bodyRef.set(charBuffer.toString());
        });
        return (String)bodyRef.get();
    }
}

