/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.controller;

import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.core.web.controller.BaseController;
import com.dgtis.common.core.web.domain.AjaxResult;
import com.dgtis.common.core.web.page.TableDataInfo;
import com.dgtis.common.log.annotation.Log;
import com.dgtis.common.log.enums.BusinessType;
import com.dgtis.common.redis.service.RedisService;
import com.dgtis.common.security.annotation.PreAuthorize;
import com.dgtis.system.api.model.LoginUser;
import com.dgtis.system.domain.SysUserOnline;
import com.dgtis.system.service.ISysUserOnlineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/online"})
public class SysUserOnlineController
extends BaseController {
    @Autowired
    private ISysUserOnlineService userOnlineService;
    @Autowired
    private RedisService redisService;

    @PreAuthorize(hasPermi="monitor:online:list")
    @GetMapping(value={"/list"})
    public TableDataInfo list(String ipaddr, String userName) {
        Collection keys = this.redisService.keys("login_tokens:*");
        ArrayList<SysUserOnline> userOnlineList = new ArrayList<SysUserOnline>();
        for (String key : keys) {
            LoginUser user = (LoginUser)this.redisService.getCacheObject(key);
            if (StringUtils.isNotEmpty((String)ipaddr) && StringUtils.isNotEmpty((String)userName)) {
                if (!StringUtils.equals((CharSequence)ipaddr, (CharSequence)user.getIpaddr()) || !StringUtils.equals((CharSequence)userName, (CharSequence)user.getUsername())) continue;
                userOnlineList.add(this.userOnlineService.selectOnlineByInfo(ipaddr, userName, user));
                continue;
            }
            if (StringUtils.isNotEmpty((String)ipaddr)) {
                if (!StringUtils.equals((CharSequence)ipaddr, (CharSequence)user.getIpaddr())) continue;
                userOnlineList.add(this.userOnlineService.selectOnlineByIpaddr(ipaddr, user));
                continue;
            }
            if (StringUtils.isNotEmpty((String)userName)) {
                if (!StringUtils.equals((CharSequence)userName, (CharSequence)user.getUsername())) continue;
                userOnlineList.add(this.userOnlineService.selectOnlineByUserName(userName, user));
                continue;
            }
            userOnlineList.add(this.userOnlineService.loginUserToUserOnline(user));
        }
        Collections.reverse(userOnlineList);
        userOnlineList.removeAll(Collections.singleton(null));
        return this.getDataTable(userOnlineList);
    }

    @PreAuthorize(hasPermi="monitor:online:forceLogout")
    @Log(title="\u5728\u7ebf\u7528\u6237", businessType=BusinessType.FORCE)
    @DeleteMapping(value={"/{tokenId}"})
    public AjaxResult forceLogout(@PathVariable String tokenId) {
        this.redisService.deleteObject("login_tokens:" + tokenId);
        return AjaxResult.success();
    }
}

