/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.service.impl;

import com.dgtis.common.core.exception.CustomException;
import com.dgtis.common.core.text.Convert;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.redis.service.RedisService;
import com.dgtis.system.domain.SysConfig;
import com.dgtis.system.mapper.SysConfigMapper;
import com.dgtis.system.service.ISysConfigService;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysConfigServiceImpl
implements ISysConfigService {
    @Autowired
    private SysConfigMapper configMapper;
    @Autowired
    private RedisService redisService;

    @PostConstruct
    public void init() {
        List configsList = this.configMapper.selectConfigList(new SysConfig());
        for (SysConfig config : configsList) {
            this.redisService.setCacheObject(this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
    }

    public SysConfig selectConfigById(Long configId) {
        SysConfig config = new SysConfig();
        config.setConfigId(configId);
        return this.configMapper.selectConfig(config);
    }

    public String selectConfigByKey(String configKey) {
        String configValue = Convert.toStr((Object)this.redisService.getCacheObject(this.getCacheKey(configKey)));
        if (StringUtils.isNotEmpty((String)configValue)) {
            return configValue;
        }
        SysConfig config = new SysConfig();
        config.setConfigKey(configKey);
        SysConfig retConfig = this.configMapper.selectConfig(config);
        if (StringUtils.isNotNull((Object)retConfig)) {
            this.redisService.setCacheObject(this.getCacheKey(configKey), (Object)retConfig.getConfigValue());
            return retConfig.getConfigValue();
        }
        return "";
    }

    public List<SysConfig> selectConfigList(SysConfig config) {
        return this.configMapper.selectConfigList(config);
    }

    public int insertConfig(SysConfig config) {
        int row = this.configMapper.insertConfig(config);
        if (row > 0) {
            this.redisService.setCacheObject(this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
        return row;
    }

    public int updateConfig(SysConfig config) {
        int row = this.configMapper.updateConfig(config);
        if (row > 0) {
            this.redisService.setCacheObject(this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
        return row;
    }

    public int deleteConfigByIds(Long[] configIds) {
        for (Long configId : configIds) {
            SysConfig config = this.selectConfigById(configId);
            if (!StringUtils.equals((CharSequence)"Y", (CharSequence)config.getConfigType())) continue;
            throw new CustomException(String.format("\u5185\u7f6e\u53c2\u6570\u3010%1$s\u3011\u4e0d\u80fd\u5220\u9664 ", config.getConfigKey()));
        }
        int count = this.configMapper.deleteConfigByIds(configIds);
        if (count > 0) {
            Collection keys = this.redisService.keys("sys_config:*");
            this.redisService.deleteObject(keys);
        }
        return count;
    }

    public void clearCache() {
        Collection keys = this.redisService.keys("sys_config:*");
        this.redisService.deleteObject(keys);
    }

    public String checkConfigKeyUnique(SysConfig config) {
        Long configId = StringUtils.isNull((Object)config.getConfigId()) ? -1L : config.getConfigId();
        SysConfig info = this.configMapper.checkConfigKeyUnique(config.getConfigKey());
        if (StringUtils.isNotNull((Object)info) && info.getConfigId().longValue() != configId.longValue()) {
            return "1";
        }
        return "0";
    }

    private String getCacheKey(String configKey) {
        return "sys_config:" + configKey;
    }
}

