/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BeeLineSignalHandler;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalHandler
implements BeeLineSignalHandler,
SignalHandler {
    private Statement stmt = null;
    private Connection conn = null;
    private BeeLine beeLine = null;

    SunSignalHandler() {
        Signal.handle(new Signal("INT"), this);
    }

    @Override
    public void setBeeLine(BeeLine beeLine) {
        this.beeLine = beeLine;
    }

    @Override
    public void setStatement(Statement stmt) {
        this.stmt = stmt;
    }

    @Override
    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Signal signal) {
        block7: {
            try {
                if (this.stmt != null && !this.stmt.isClosed()) {
                    this.print("canceling running sql ...");
                    this.beeLine.setIgnoreErrorMsg(true);
                    try {
                        this.stmt.cancel();
                        break block7;
                    }
                    finally {
                        this.beeLine.setIgnoreErrorMsg(false);
                    }
                }
                if (this.conn != null && !this.conn.isClosed()) {
                    this.print("closing connection ...");
                    this.conn.close();
                }
                this.print("quit beeline");
                System.exit(0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void print(String msg) {
        if (this.beeLine != null) {
            this.beeLine.info(msg);
        }
    }
}

