/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.controller;

import com.dgtis.common.core.domain.R;
import com.dgtis.common.core.utils.ServletUtils;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.core.web.controller.BaseController;
import com.dgtis.common.core.web.domain.AjaxResult;
import com.dgtis.common.log.annotation.Log;
import com.dgtis.common.log.enums.BusinessType;
import com.dgtis.common.security.service.TokenService;
import com.dgtis.common.security.utils.SecurityUtils;
import com.dgtis.system.api.RemoteFileService;
import com.dgtis.system.api.domain.SysFile;
import com.dgtis.system.api.domain.SysUser;
import com.dgtis.system.api.model.LoginUser;
import com.dgtis.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/user/profile"})
public class SysProfileController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private RemoteFileService remoteFileService;

    @GetMapping
    public AjaxResult profile() {
        String username = SecurityUtils.getUsername();
        SysUser user = this.userService.selectUserByUserName(username);
        AjaxResult ajax = AjaxResult.success((Object)user);
        ajax.put((Object)"roleGroup", (Object)this.userService.selectUserRoleGroup(username));
        ajax.put((Object)"postGroup", (Object)this.userService.selectUserPostGroup(username));
        return ajax;
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult updateProfile(@RequestBody SysUser user) {
        if (this.userService.updateUserProfile(user) > 0) {
            LoginUser loginUser = this.tokenService.getLoginUser();
            loginUser.getSysUser().setNickName(user.getNickName());
            loginUser.getSysUser().setPhonenumber(user.getPhonenumber());
            loginUser.getSysUser().setEmail(user.getEmail());
            loginUser.getSysUser().setSex(user.getSex());
            this.tokenService.setLoginUser(loginUser);
            return AjaxResult.success();
        }
        return AjaxResult.error((String)"\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updatePwd"})
    public AjaxResult updatePwd(String oldPassword, String newPassword) {
        String username = SecurityUtils.getUsername();
        SysUser user = this.userService.selectUserByUserName(username);
        String password = user.getPassword();
        if (!SecurityUtils.matchesPassword((String)oldPassword, (String)password)) {
            return AjaxResult.error((String)"\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        if (SecurityUtils.matchesPassword((String)newPassword, (String)password)) {
            return AjaxResult.error((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        if (this.userService.resetUserPwd(username, SecurityUtils.encryptPassword((String)newPassword)) > 0) {
            LoginUser loginUser = this.tokenService.getLoginUser();
            loginUser.getSysUser().setPassword(SecurityUtils.encryptPassword((String)newPassword));
            this.tokenService.setLoginUser(loginUser);
            return AjaxResult.success();
        }
        return AjaxResult.error((String)"\u4fee\u6539\u5bc6\u7801\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Log(title="\u7528\u6237\u5934\u50cf", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/avatar"})
    public AjaxResult avatar(@RequestParam(value="avatarfile") MultipartFile file) {
        if (!file.isEmpty()) {
            LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
            R fileResult = this.remoteFileService.upload(file);
            if (StringUtils.isNull((Object)fileResult) || StringUtils.isNull((Object)fileResult.getData())) {
                return AjaxResult.error((String)"\u6587\u4ef6\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            String url = ((SysFile)fileResult.getData()).getUrl();
            if (this.userService.updateUserAvatar(loginUser.getUsername(), url)) {
                AjaxResult ajax = AjaxResult.success();
                ajax.put((Object)"imgUrl", (Object)url);
                loginUser.getSysUser().setAvatar(url);
                this.tokenService.setLoginUser(loginUser);
                return ajax;
            }
        }
        return AjaxResult.error((String)"\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

