/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.controller;

import com.dgtis.common.core.utils.poi.ExcelUtil;
import com.dgtis.common.core.web.controller.BaseController;
import com.dgtis.common.core.web.domain.AjaxResult;
import com.dgtis.common.core.web.page.TableDataInfo;
import com.dgtis.common.log.annotation.Log;
import com.dgtis.common.log.enums.BusinessType;
import com.dgtis.common.security.annotation.PreAuthorize;
import com.dgtis.common.security.utils.SecurityUtils;
import com.dgtis.system.api.domain.SysRole;
import com.dgtis.system.service.ISysRoleService;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"})
public class SysRoleController
extends BaseController {
    @Autowired
    private ISysRoleService roleService;

    @PreAuthorize(hasPermi="system:role:list")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRole role) {
        this.startPage();
        List list = this.roleService.selectRoleList(role);
        return this.getDataTable(list);
    }

    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(hasPermi="system:role:export")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysRole role) throws IOException {
        List list = this.roleService.selectRoleList(role);
        ExcelUtil util = new ExcelUtil(SysRole.class);
        util.exportExcel(response, list, "\u89d2\u8272\u6570\u636e");
    }

    @PreAuthorize(hasPermi="system:role:query")
    @GetMapping(value={"/{roleId}"})
    public AjaxResult getInfo(@PathVariable Long roleId) {
        return AjaxResult.success((Object)this.roleService.selectRoleById(roleId));
    }

    @PreAuthorize(hasPermi="system:role:add")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysRole role) {
        if ("1".equals(this.roleService.checkRoleNameUnique(role))) {
            return AjaxResult.error((String)("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728"));
        }
        if ("1".equals(this.roleService.checkRoleKeyUnique(role))) {
            return AjaxResult.error((String)("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728"));
        }
        role.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.insertRole(role));
    }

    @PreAuthorize(hasPermi="system:role:edit")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        if ("1".equals(this.roleService.checkRoleNameUnique(role))) {
            return AjaxResult.error((String)("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728"));
        }
        if ("1".equals(this.roleService.checkRoleKeyUnique(role))) {
            return AjaxResult.error((String)("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728"));
        }
        role.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.updateRole(role));
    }

    @PreAuthorize(hasPermi="system:role:edit")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/dataScope"})
    public AjaxResult dataScope(@RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        return this.toAjax(this.roleService.authDataScope(role));
    }

    @PreAuthorize(hasPermi="system:role:edit")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult changeStatus(@RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        role.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.updateRoleStatus(role));
    }

    @PreAuthorize(hasPermi="system:role:remove")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{roleIds}"})
    public AjaxResult remove(@PathVariable Long[] roleIds) {
        return this.toAjax(this.roleService.deleteRoleByIds(roleIds));
    }

    @PreAuthorize(hasPermi="system:role:query")
    @GetMapping(value={"/optionselect"})
    public AjaxResult optionselect() {
        return AjaxResult.success((Object)this.roleService.selectRoleAll());
    }
}

