/*
 * Decompiled with CFR 0.152.
 */
package com.dgtis.system.service.impl;

import com.dgtis.common.core.exception.CustomException;
import com.dgtis.common.core.utils.StringUtils;
import com.dgtis.common.datascope.annotation.DataScope;
import com.dgtis.system.api.domain.SysDept;
import com.dgtis.system.api.domain.SysRole;
import com.dgtis.system.domain.vo.TreeSelect;
import com.dgtis.system.mapper.SysDeptMapper;
import com.dgtis.system.mapper.SysRoleMapper;
import com.dgtis.system.service.ISysDeptService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDeptServiceImpl
implements ISysDeptService {
    @Autowired
    private SysDeptMapper deptMapper;
    @Autowired
    private SysRoleMapper roleMapper;

    @DataScope(deptAlias="d")
    public List<SysDept> selectDeptList(SysDept dept) {
        return this.deptMapper.selectDeptList(dept);
    }

    public List<SysDept> buildDeptTree(List<SysDept> depts) {
        List<SysDept> returnList = new ArrayList<SysDept>();
        ArrayList<Long> tempList = new ArrayList<Long>();
        for (SysDept dept : depts) {
            tempList.add(dept.getDeptId());
        }
        for (SysDept dept : depts) {
            if (tempList.contains(dept.getParentId())) continue;
            this.recursionFn(depts, dept);
            returnList.add(dept);
        }
        if (returnList.isEmpty()) {
            returnList = depts;
        }
        return returnList;
    }

    public List<TreeSelect> buildDeptTreeSelect(List<SysDept> depts) {
        List deptTrees = this.buildDeptTree(depts);
        return deptTrees.stream().map(TreeSelect::new).collect(Collectors.toList());
    }

    public List<Integer> selectDeptListByRoleId(Long roleId) {
        SysRole role = this.roleMapper.selectRoleById(roleId);
        return this.deptMapper.selectDeptListByRoleId(roleId, role.isDeptCheckStrictly());
    }

    public SysDept selectDeptById(Long deptId) {
        return this.deptMapper.selectDeptById(deptId);
    }

    public int selectNormalChildrenDeptById(Long deptId) {
        return this.deptMapper.selectNormalChildrenDeptById(deptId);
    }

    public boolean hasChildByDeptId(Long deptId) {
        int result = this.deptMapper.hasChildByDeptId(deptId);
        return result > 0;
    }

    public boolean checkDeptExistUser(Long deptId) {
        int result = this.deptMapper.checkDeptExistUser(deptId);
        return result > 0;
    }

    public String checkDeptNameUnique(SysDept dept) {
        Long deptId = StringUtils.isNull((Object)dept.getDeptId()) ? -1L : dept.getDeptId();
        SysDept info = this.deptMapper.checkDeptNameUnique(dept.getDeptName(), dept.getParentId());
        if (StringUtils.isNotNull((Object)info) && info.getDeptId().longValue() != deptId.longValue()) {
            return "1";
        }
        return "0";
    }

    public int insertDept(SysDept dept) {
        SysDept info = this.deptMapper.selectDeptById(dept.getParentId());
        if (!"0".equals(info.getStatus())) {
            throw new CustomException("\u90e8\u95e8\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        dept.setAncestors(info.getAncestors() + "," + dept.getParentId());
        return this.deptMapper.insertDept(dept);
    }

    public int updateDept(SysDept dept) {
        SysDept newParentDept = this.deptMapper.selectDeptById(dept.getParentId());
        SysDept oldDept = this.deptMapper.selectDeptById(dept.getDeptId());
        if (StringUtils.isNotNull((Object)newParentDept) && StringUtils.isNotNull((Object)oldDept)) {
            String newAncestors = newParentDept.getAncestors() + "," + newParentDept.getDeptId();
            String oldAncestors = oldDept.getAncestors();
            dept.setAncestors(newAncestors);
            this.updateDeptChildren(dept.getDeptId(), newAncestors, oldAncestors);
        }
        int result = this.deptMapper.updateDept(dept);
        if ("0".equals(dept.getStatus())) {
            this.updateParentDeptStatus(dept);
        }
        return result;
    }

    private void updateParentDeptStatus(SysDept dept) {
        String updateBy = dept.getUpdateBy();
        dept = this.deptMapper.selectDeptById(dept.getDeptId());
        dept.setUpdateBy(updateBy);
        this.deptMapper.updateDeptStatus(dept);
    }

    public void updateDeptChildren(Long deptId, String newAncestors, String oldAncestors) {
        List children = this.deptMapper.selectChildrenDeptById(deptId);
        for (SysDept child : children) {
            child.setAncestors(child.getAncestors().replace(oldAncestors, newAncestors));
        }
        if (children.size() > 0) {
            this.deptMapper.updateDeptChildren(children);
        }
    }

    public int deleteDeptById(Long deptId) {
        return this.deptMapper.deleteDeptById(deptId);
    }

    private void recursionFn(List<SysDept> list, SysDept t) {
        List childList = this.getChildList(list, t);
        t.setChildren(childList);
        for (SysDept tChild : childList) {
            if (!this.hasChild(list, tChild)) continue;
            this.recursionFn(list, tChild);
        }
    }

    private List<SysDept> getChildList(List<SysDept> list, SysDept t) {
        ArrayList<SysDept> tlist = new ArrayList<SysDept>();
        for (SysDept n : list) {
            if (!StringUtils.isNotNull((Object)n.getParentId()) || n.getParentId().longValue() != t.getDeptId().longValue()) continue;
            tlist.add(n);
        }
        return tlist;
    }

    private boolean hasChild(List<SysDept> list, SysDept t) {
        return this.getChildList(list, t).size() > 0;
    }
}

